package com.artfess.gyl.supplierApply2.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 检验设备表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-26
 */
@Data
@ApiModel(value="BizSupplierInspectionEquipment2对象", description="检验设备表")
public class BizSupplierInspectionEquipment2 extends BizDelModel<BizSupplierInspectionEquipment2> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "供应商准入ID")
    @TableField("SUPPLIER_ENTERPRISE_ID_")
    private String supplierEnterpriseId;

    @ApiModelProperty(value = "生产监测/设备名称、型号")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "产能/精度")
    @TableField("CAPACITY_")
    private String capacity;

    @ApiModelProperty(value = "数量")
    @TableField("NUM_")
    private String num;

    @ApiModelProperty(value = "生产厂家")
    @TableField("MANUFACTURER_")
    private String manufacturer;

    @ApiModelProperty(value = "使用年限")
    @TableField("SERVICE_LIFE_")
    private String serviceLife;
}
