package com.artfess.gyl.supplierApply2.manager.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.StrUtil;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.base.manager.*;
import com.artfess.gyl.base.model.*;
import com.artfess.gyl.supplierAccess.dto.BizSupplierAccessConfigurationDto;
import com.artfess.gyl.supplierAccess.manager.*;
import com.artfess.gyl.supplierAccess.model.*;
import com.artfess.gyl.supplierAccess.vo.BizSupplierAccessConfigurationVo;
import com.artfess.gyl.supplierAccess.vo.BizSupplierReviewConfigurationDetailsVo;
import com.artfess.gyl.supplierAccess.vo.BizSupplierReviewConfigurationVo;
import com.artfess.gyl.supplierApply.dto.*;
import com.artfess.gyl.supplierApply.manager.BizSupplierAccessEnterprisePersonnelManager;
import com.artfess.gyl.supplierApply.manager.BizSupplierEnterpriseManager;
import com.artfess.gyl.supplierApply.model.*;
import com.artfess.gyl.supplierApply.vo.BizSupplierProductionProcessPerformanceVo;
import com.artfess.gyl.supplierApply2.dto.*;
import com.artfess.gyl.supplierApply2.manager.*;
import com.artfess.gyl.supplierApply2.model.*;
import com.artfess.gyl.supplierApply2.dao.BizSupplierEnterpriseAccessDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.supplierApply2.vo.*;
import com.artfess.gyl.thirdParty.manager.BizCategoryManager;
import com.artfess.gyl.thirdParty.manager.BizEnterpriseManager;
import com.artfess.gyl.thirdParty.model.BizCategory;
import com.artfess.gyl.thirdParty.model.BizEnterprise;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import org.apache.http.util.Asserts;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 供应商准入申请表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-10
 */
@Service
public class BizSupplierEnterpriseAccessManagerImpl extends BaseManagerImpl<BizSupplierEnterpriseAccessDao, BizSupplierEnterpriseAccess> implements BizSupplierEnterpriseAccessManager {

    @Resource
    private SysIdentityManager sysIdentityManager;

    @Resource
    private BizSupplierMainSupplyMaterialCategory2Manager materialCategory2Manager;

    @Resource
    private BizSupplierAccessBasicInformation2Manager information2Manager;

    @Resource
    private BizSupplierEnterpriseQualificationDatabase2Manager qualificationDatabase2Manager;

    @Resource
    private BizSupplierMainProductsPerformance2Manager mainProductsPerformance2Manager;

    @Resource
    private BizSupplierMainProductsQualityPerformance2Manager mainProductsQualityPerformance2Manager;

    @Resource
    private BizSupplierMainProductsSalesStatus2Manager mainProductsSalesStatus2Manager;

    @Resource
    private BizSupplierMainProductsPerformanceCustomerComplaints2Manager mainProductsPerformanceCustomerComplaints2Manager;

    @Resource
    private BizSupplierMainRawMaterialsSuppliers2Manager mainRawMaterialsSuppliers2Manager;

    @Resource
    private BizSupplierProductionProcessPerformance2Manager productionProcessPerformance2Manager;

    @Resource
    private BizSupplierProductionProcessFlow2Manager productionProcessFlow2Manager;

    @Resource
    private BizSupplierProductionInspectionEquipment2Manager productionInspectionEquipment2Manager;

    @Resource
    private BizSupplierOtherSpecialNotes2Manager otherSpecialNotes2Manager;

    @Resource
    private BizEnterpriseManager enterpriseManager;

    @Resource
    private BizSupplierAccessConfigurationManager accessConfigurationManager;

    @Resource
    private BizSupplierAccessQualificationManager qualificationManager;

    @Resource
    private BizSupplierQualificationCategoryManager qualificationCategoryManager;

    @Resource
    private BizSupplierQualificationDatabaseManager qualificationDatabaseManager;

    @Resource
    private BizSupplierEnterpriseAccessApprovalRecord2Manager accessApprovalRecord2Manager;

    @Resource
    private BizSupplierAccessProcessManager accessProcessManager;

    @Resource
    private BizSupplierReviewRatingDetails2Manager reviewRatingDetails2Manager;

    @Resource
    private BizSupplierReviewReport2Manager reviewReport2Manager;

    @Resource
    private BizSupplierReviewReportPanel2Manager reviewReportPanel2Manager;

    @Resource
    private BizSupplierReviewTrialReport2Manager reviewTrialReport2Manager;

    @Resource
    private BizSupplierReviewTrialReportPanel2Manager reviewTrialReportPanel2Manager;

    @Resource
    private BizSupplierReviewConfigurationManager reviewConfigurationManager;

    @Resource
    private BizSupplierReviewConfigurationDetailsManager reviewConfigurationDetailsManager;

    @Resource
    private BizSupplierEnterpriseManager supplierEnterpriseManager;

    @Resource
    private BizSupplierReviewConfigurationDetailsPanelManager reviewConfigurationDetailsPanelManager;

    @Resource
    private BizSupplierAccessPersonnel2Manager accessPersonnel2Manager;

    @Resource
    private BizSupplierReviewRatingPanel2Manager reviewRatingPanel2Manager;

    @Resource
    private BizSupplierAccessConfigurationMaterialCategoryManager accessConfigurationMaterialCategoryManager;

    @Resource
    private BizEnterprisePersonnelManager enterprisePersonnelManager;

    @Resource
    private BizSupplierAccessEnterprisePersonnel2Manager accessEnterprisePersonnel2Manager;

    @Resource
    private BizSupplierInspectionEquipment2Manager inspectionEquipment2Manager;

    @Resource
    private BizSupplierProductionEquipment2Manager productionEquipment2Manager;

    @Resource
    private BizEnterpriseBusinessLicenseManager enterpriseBusinessLicenseManager;

    @Resource
    private BizSupplierAccessBasicManager accessBasicManager;

    @Resource
    private BizCategoryManager categoryManager;

    @Resource
    private BizSupplierAccessEnterprisePersonnelManager accessEnterprisePersonnelManager;

    @Resource
    private BizSupplierGradingConfigurationManager gradingConfigurationManager;

    @Resource
    private BizSupplierGradingSupplyScopeManager gradingSupplyScopeManager;

    @Resource
    private BizSupplierCategoryConfigurationManager categoryConfigurationManager;

    @Resource
    private FileManager fileManager;

    @Override
    public Boolean saveOrUpdateEnterpriseAccess(EnterpriseAccess2Dto dto) {
        Boolean result = false;
        if (BeanUtils.isEmpty(dto.getId())){
            //新增
            result = saveEnterpriseAccess(dto);
        }
        //修改
        else {
            result = updateEnterpriseAccess(dto);
        }
        return result;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean saveOrUpdateOtherInfo(EnterpriseAccess2Dto dto) {
        Boolean result = false;
        String accessId = dto.getId();
        //如果没有主表，则新增一个主表
        if (BeanUtils.isEmpty(accessId)){
            saveEnterpriseAccess(dto);
        }
        String moduleCode = dto.getModuleCode();
        //1 基本情况
        if ("1".equals(moduleCode)){
            result = saveOrUpdateBasicInformation(dto);
        }
        //2 人员信息
        else if ("2".equals(moduleCode)) {
            result = saveOrUpdateAccessPersonel(dto);
        }
        //3 企业规模
        else if ("3".equals(moduleCode)) {
            result = saveOrUpdateBasicInformation(dto);
        }
        //4 企业资质
        else if ("4".equals(moduleCode)) {
            result = saveOrUpdateQualification(dto);
        }
        //5 主营产品情况
        else if ("5".equals(moduleCode)) {
            result = saveOrUpdateMainProductsSalesStatus(dto);
        }
        //6 主营产品质量业绩
        else if ("6".equals(moduleCode)) {
            result = saveOrUpdateMainProductsPerformance(dto);
        }
        //7 主要原材料及供应商
        else if ("7".equals(moduleCode)) {
            result = saveOrUpdateMainRawMaterialsSuppliers(dto);
        }
        //8 生产制造过程绩效
        else if ("8".equals(moduleCode)) {
            result = saveOrUpdateProductionProcessPerformance(dto);
        }
        //9 生产设备
        else if ("9".equals(moduleCode)) {
            result = saveOrUpdateProductionEquipment(dto);
        }
        //10 检验设备
        else if ("10".equals(moduleCode)) {
            result = saveOrUpdateInspectionEquipment(dto);
        }
        //11 其他特别说明
        else if ("11".equals(moduleCode)) {
            result = saveOrUpdateOtherSpecialNotes(dto);
        }
        //12 现场评审
        else if ("12".equals(moduleCode)) {
            result = saveOrUpdateReviewRatingDetails(dto);
        }
        //13 评定报告
        else if ("13".equals(moduleCode)) {
            result = saveOrUpdateReviewReport(dto);
        }
        //14 试生产审评
        else if ("14".equals(moduleCode)) {
            result = saveOrUpdateReviewTrialReport(dto);
        }
        return result;
    }

    /**
     * 人员信息
     * @param dto
     * @return
     */
    private Boolean saveOrUpdateAccessPersonel(EnterpriseAccess2Dto dto) {
        //如果准入申请信息为空，则新增准入信息
        if (BeanUtils.isEmpty(dto.getId())){
            saveEnterpriseAccess(dto);
        }
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        //删除旧数据
        accessEnterprisePersonnel2Manager.remove(new LambdaQueryWrapper<BizSupplierAccessEnterprisePersonnel2>()
                .eq(BizSupplierAccessEnterprisePersonnel2::getSupplierEnterpriseId,supplierEnterpriseId)
                .eq(BizSupplierAccessEnterprisePersonnel2::getIsDele,"0"));

        //保存新数据
        List<BizSupplierAccessEnterprisePersonnel2> personnelList = dto.getEnterprisePersonnelList();
        personnelList.forEach(p -> {
            p.setSupplierEnterpriseId(dto.getId());
            p.setIsDele("0");
            p.setId(null);
        });
        accessEnterprisePersonnel2Manager.saveBatch(personnelList);
        return true;
    }

    @Override
    public EnterpriseAccess2Vo getInfo(String id) {
        BizSupplierEnterpriseAccess enterpriseAccess = get(id);
        EnterpriseAccess2Vo enterpriseAccess2Vo = new EnterpriseAccess2Vo(enterpriseAccess);
        //供应物资
        List<BizSupplierMainSupplyMaterialCategory2> mainSupplyMaterialCategory2List = materialCategory2Manager.list(new LambdaQueryWrapper<BizSupplierMainSupplyMaterialCategory2>()
                .eq(BizSupplierMainSupplyMaterialCategory2::getSupplierEnterpriseId, id)
                .eq(BizSupplierMainSupplyMaterialCategory2::getIsDele, "0"));
        enterpriseAccess2Vo.setMaterialCategory2List(mainSupplyMaterialCategory2List);

        //基本情况 企业规模
        BizSupplierAccessBasicInformation2 information2 = information2Manager.getOne(new LambdaQueryWrapper<BizSupplierAccessBasicInformation2>()
                .eq(BizSupplierAccessBasicInformation2::getSupplierEnterpriseId, id)
                .eq(BizSupplierAccessBasicInformation2::getIsDele, "0"));
        if (BeanUtils.isNotEmpty(information2)){
            BizSupplierAccessBasicInformation2Vo information2Vo = new BizSupplierAccessBasicInformation2Vo(information2);
            BizEnterprise enterprise = enterpriseManager.getOne(new LambdaQueryWrapper<BizEnterprise>()
                    .eq(BizEnterprise::getOrgId, information2.getEnterpriseId())
                    .eq(BizEnterprise::getIsDele,"0"));
            information2Vo.setEnterprise(enterprise);
            enterpriseAccess2Vo.setInformation(information2Vo);
        }

        //企业资质
        List<BizSupplierEnterpriseQualificationDatabase2> qualificationList = qualificationDatabase2Manager.list(new LambdaQueryWrapper<BizSupplierEnterpriseQualificationDatabase2>()
                .eq(BizSupplierEnterpriseQualificationDatabase2::getSupplierEnterpriseId, id)
                .eq(BizSupplierEnterpriseQualificationDatabase2::getIsDele, "0"));
        Map<String, List<BizSupplierEnterpriseQualificationDatabase2>> qualificationMap = qualificationList.stream()
                .collect(Collectors.groupingBy(BizSupplierEnterpriseQualificationDatabase2::getMustTransmit));
        enterpriseAccess2Vo.setQualificationMap(qualificationMap);
        //主营产品情况
        List<BizSupplierMainProductsSalesStatus2> salesStatus2List = mainProductsSalesStatus2Manager.list(new LambdaQueryWrapper<BizSupplierMainProductsSalesStatus2>()
                .eq(BizSupplierMainProductsSalesStatus2::getSupplierEnterpriseId, id)
                .eq(BizSupplierMainProductsSalesStatus2::getIsDele, "0"));
        enterpriseAccess2Vo.setSalesStatus2List(salesStatus2List);
        //主营产品质量业绩
        BizSupplierMainProductsPerformance2 performance2 = mainProductsPerformance2Manager.getOne(new LambdaQueryWrapper<BizSupplierMainProductsPerformance2>()
                .eq(BizSupplierMainProductsPerformance2::getSupplierEnterpriseId, id)
                .eq(BizSupplierMainProductsPerformance2::getIsDele, "0"));
        if (BeanUtils.isNotEmpty(performance2)){
            MainProductsPerformance2Vo performance2Vo = new MainProductsPerformance2Vo(performance2);
            String productsPerformanceId = performance2Vo.getId();
            List<BizSupplierMainProductsQualityPerformance2> qualityPerformance2List = mainProductsQualityPerformance2Manager.list(new LambdaQueryWrapper<BizSupplierMainProductsQualityPerformance2>()
                    .eq(BizSupplierMainProductsQualityPerformance2::getSupplierMainProductsPerformanceId, productsPerformanceId)
                    .eq(BizSupplierMainProductsQualityPerformance2::getIsDele, "0"));
            List<BizSupplierMainProductsPerformanceCustomerComplaints2> customerComplaints2List = mainProductsPerformanceCustomerComplaints2Manager.list(new LambdaQueryWrapper<BizSupplierMainProductsPerformanceCustomerComplaints2>()
                    .eq(BizSupplierMainProductsPerformanceCustomerComplaints2::getSupplierMainProductsPerformanceId, productsPerformanceId)
                    .eq(BizSupplierMainProductsPerformanceCustomerComplaints2::getIsDele, "0"));
            performance2Vo.setQualityPerformance2List(qualityPerformance2List);
            performance2Vo.setCustomerComplaints2List(customerComplaints2List);
            if (BeanUtils.isNotEmpty(performance2Vo)){
                List<DefaultFile> defaultFiles = fileManager.queryFileByBizId(performance2Vo.getId());
                if (CollectionUtils.isNotEmpty(defaultFiles)){
                    performance2Vo.setFiles(defaultFiles);
                }
            }
            enterpriseAccess2Vo.setMainProductsPerformance(performance2Vo);
        }
        //主要原材料及供应商
        List<BizSupplierMainRawMaterialsSuppliers2> mainRawMaterialsSuppliers2List = mainRawMaterialsSuppliers2Manager.list(new LambdaQueryWrapper<BizSupplierMainRawMaterialsSuppliers2>()
                .eq(BizSupplierMainRawMaterialsSuppliers2::getSupplierEnterpriseId, id)
                .eq(BizSupplierMainRawMaterialsSuppliers2::getIsDele, "0"));
        enterpriseAccess2Vo.setRawMaterialsSuppliersList(mainRawMaterialsSuppliers2List);
        //生产制造过程绩效
        BizSupplierProductionProcessPerformance2 processPerformance2 = productionProcessPerformance2Manager.getOne(new LambdaQueryWrapper<BizSupplierProductionProcessPerformance2>()
                .eq(BizSupplierProductionProcessPerformance2::getSupplierEnterpriseId, id)
                .eq(BizSupplierProductionProcessPerformance2::getIsDele, "0"));
        if (BeanUtils.isNotEmpty(processPerformance2)){
            BizSupplierProductionProcessPerformance2Vo processPerformance2Vo = new BizSupplierProductionProcessPerformance2Vo(processPerformance2);
            String processPerformance2Id = processPerformance2.getId();
            List<BizSupplierProductionProcessFlow2> productionProcessFlow2List = productionProcessFlow2Manager.list(new LambdaQueryWrapper<BizSupplierProductionProcessFlow2>()
                    .eq(BizSupplierProductionProcessFlow2::getSupplierProductionProcessPerformanceId, processPerformance2Id)
                    .eq(BizSupplierProductionProcessFlow2::getIsDele, "0"));
            processPerformance2Vo.setProcessFlow2List(productionProcessFlow2List);
            if (BeanUtils.isNotEmpty(processPerformance2Vo)){
                List<DefaultFile> defaultFiles = fileManager.queryFileByBizId(processPerformance2Vo.getId());
                if (CollectionUtils.isNotEmpty(defaultFiles)){
                    processPerformance2Vo.setFiles(defaultFiles);
                }
            }
            enterpriseAccess2Vo.setProcessPerformance(processPerformance2Vo);
        }
        //生产设备
        List<BizSupplierProductionEquipment2> productionEquipment2List = productionEquipment2Manager.list(new LambdaQueryWrapper<BizSupplierProductionEquipment2>()
                .eq(BizSupplierProductionEquipment2::getSupplierEnterpriseId, id)
                .eq(BizSupplierProductionEquipment2::getIsDele, "0"));
        enterpriseAccess2Vo.setProductionEquipment2List(productionEquipment2List);
        List<DefaultFile> productionEquipmentFiles = fileManager.queryFileByBizId(id,"productionEquipment");
        if (CollectionUtils.isNotEmpty(productionEquipmentFiles)){
            enterpriseAccess2Vo.setProductionEquipmentFiles(productionEquipmentFiles);
        }
        //检验设备
        List<BizSupplierInspectionEquipment2> inspectionEquipment2List = inspectionEquipment2Manager.list(new LambdaQueryWrapper<BizSupplierInspectionEquipment2>()
                .eq(BizSupplierInspectionEquipment2::getSupplierEnterpriseId, id)
                .eq(BizSupplierInspectionEquipment2::getIsDele, "0"));
        enterpriseAccess2Vo.setInspectionEquipment2List(inspectionEquipment2List);
        List<DefaultFile> inspectionEquipmentFiles = fileManager.queryFileByBizId(id,"inspectionEquipment");
        if (CollectionUtils.isNotEmpty(inspectionEquipmentFiles)){
            enterpriseAccess2Vo.setInspectionEquipmentFiles(inspectionEquipmentFiles);
        }
        //其他特别说明
        BizSupplierOtherSpecialNotes2 otherSpecialNotes2 = otherSpecialNotes2Manager.getOne(new LambdaQueryWrapper<BizSupplierOtherSpecialNotes2>()
                .eq(BizSupplierOtherSpecialNotes2::getSupplierEnterpriseId, id)
                .eq(BizSupplierOtherSpecialNotes2::getIsDele, "0"));
        if (BeanUtils.isNotEmpty(otherSpecialNotes2)){
            List<DefaultFile> defaultFiles = fileManager.queryFileByBizId(otherSpecialNotes2.getId());
            if (CollectionUtils.isNotEmpty(defaultFiles)){
                otherSpecialNotes2.setFiles(defaultFiles);
            }
        }
        enterpriseAccess2Vo.setOtherSpecialNotes(otherSpecialNotes2);
        //现场评审
        String userId = ContextUtil.getCurrentUserId();
        List<BizSupplierReviewRatingDetails2Vo> reviewRatingDetails2VoList = reviewRatingDetails2Manager.queryWithPanel(id,userId);

        String status = enterpriseAccess.getStatus();
        if ("5".equals(status) || "6".equals(status)){
            reviewRatingDetails2VoList = reviewRatingDetails2Manager.queryWithPanel(id,null);
        }

        Map<String, List<BizSupplierReviewRatingDetails2Vo>> reviewRatingDetails2Map = reviewRatingDetails2VoList.stream()
                .collect(Collectors.groupingBy(BizSupplierReviewRatingDetails2Vo::getClassificationName));
        enterpriseAccess2Vo.setReviewRatingDetails2Map(reviewRatingDetails2Map);
        //评定报告
        BizSupplierReviewReport2 reviewReport2 = reviewReport2Manager.getOne(new LambdaQueryWrapper<BizSupplierReviewReport2>()
                .eq(BizSupplierReviewReport2::getSupplierEnterpriseId, id)
                .eq(BizSupplierReviewReport2::getIsDele, "0"));
        if (BeanUtils.isNotEmpty(reviewReport2)){
            BizSupplierReviewReport2Vo reviewReport2Vo = new BizSupplierReviewReport2Vo(reviewReport2);
            String reviewReport2Id = reviewReport2.getId();
            List<BizSupplierReviewReportPanel2> panel2List = reviewReportPanel2Manager.list(new LambdaQueryWrapper<BizSupplierReviewReportPanel2>()
                    .eq(BizSupplierReviewReportPanel2::getReviewReportId, reviewReport2Id)
                    .eq(BizSupplierReviewReportPanel2::getIsDele, "0"));
            reviewReport2Vo.setPanel2List(panel2List);
            enterpriseAccess2Vo.setReviewReport(reviewReport2Vo);
        }
        //试生产评审
        BizSupplierReviewTrialReport2 reviewTrialReport2 = reviewTrialReport2Manager.getOne(new LambdaQueryWrapper<BizSupplierReviewTrialReport2>()
                .eq(BizSupplierReviewTrialReport2::getSupplierEnterpriseId, id)
                .eq(BizSupplierReviewTrialReport2::getIsDele, "0"));
        if (BeanUtils.isNotEmpty(reviewTrialReport2)){
            BizSupplierReviewTrialReport2Vo reviewTrialReport2Vo = new BizSupplierReviewTrialReport2Vo(reviewTrialReport2);
            String trialReport2Id = reviewTrialReport2.getId();
            List<BizSupplierReviewTrialReportPanel2> reviewTrialReportPanel2List = reviewTrialReportPanel2Manager.list(new LambdaQueryWrapper<BizSupplierReviewTrialReportPanel2>()
                    .eq(BizSupplierReviewTrialReportPanel2::getReviewReportId, trialReport2Id)
                    .eq(BizSupplierReviewTrialReportPanel2::getIsDele, "0"));
            reviewTrialReport2Vo.setPanel2List(reviewTrialReportPanel2List);
            enterpriseAccess2Vo.setReviewTrialReport(reviewTrialReport2Vo);
        }
        //人员信息
        List<BizSupplierAccessEnterprisePersonnel2> personnel2List = accessEnterprisePersonnel2Manager.list(new LambdaQueryWrapper<BizSupplierAccessEnterprisePersonnel2>()
                .eq(BizSupplierAccessEnterprisePersonnel2::getSupplierEnterpriseId, id)
                .eq(BizSupplierAccessEnterprisePersonnel2::getIsDele, "0"));
        enterpriseAccess2Vo.setEnterprisePersonnelList(personnel2List);
        return enterpriseAccess2Vo;
    }

    @Override
    public PageList<EnterpriseAccess2PageVo> queryPage(QueryFilter<BizSupplierEnterpriseAccess> queryFilter) throws InvocationTargetException, IllegalAccessException {
        String userId = ContextUtil.getCurrentUserId();
        IPage<EnterpriseAccess2PageVo> iPage = baseMapper.queryPage(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()),userId);
        return new PageList<>(iPage);
    }

    private FillingProgressVo createFillingProgress(String id){
        FillingProgressVo vo = new FillingProgressVo();
        BizSupplierEnterpriseAccess enterpriseAccess = get(id);
        BizSupplierAccessBasic accessBasic = accessBasicManager.getOne(new LambdaQueryWrapper<BizSupplierAccessBasic>()
                .eq(BizSupplierAccessBasic::getSupplierAccessId, enterpriseAccess.getAccessConfigurationId())
                .eq(BizSupplierAccessBasic::getIsDele, "0"));
        String code = accessBasic.getCode();
        List<String> modelCode = Arrays.stream(code.split(",")).collect(Collectors.toList());
        //基本情况
        if (modelCode.contains("1")){
            vo.setBasicInformationFlag1("0");
        }
        //人员信息
        if (modelCode.contains("2")){
            vo.setAccessPersonnelFlag("0");
        }
        //企业规模
        if (modelCode.contains("3")){
            vo.setBasicInformationFlag2("0");
        }
        //企业资质
        if (modelCode.contains("4")){
            vo.setQualificationFlag("0");
        }
        //主营产品情况
        if (modelCode.contains("5")){
            vo.setMainProductsSalesStatusFlag("0");
        }
        //主营产品质量业绩
        if (modelCode.contains("6")){
            vo.setMainProductsPerformanceFlag("0");
        }
        //主要原材料及供应商
        if (modelCode.contains("7")){
            vo.setMainRawMaterialsSuppliersFlag("0");
        }
        //生产过程绩效
        if (modelCode.contains("8")){
            vo.setProductionProcessPerformanceFlag("0");
        }
        //主要生产设备
        if (modelCode.contains("9")){
            vo.setProductionEquipmentFlag("0");
        }
        //主要检验设备
        if (modelCode.contains("10")){
            vo.setInspectionEquipmentFlag("0");
        }
        //其他特别说明
        if (modelCode.contains("11")){
            vo.setOtherSpecialNotesFlag("0");
        }
        return vo;
    }

    @Override
    public FillingProgressVo getFillingProgress(String id) {
        FillingProgressVo vo = createFillingProgress(id);
        if (BeanUtils.isEmpty(id)){
            return vo;
        }
        vo.setEnterpriseAccessFlag("1");
        //基本情况 企业规模
        int count1 = information2Manager.count(new LambdaQueryWrapper<BizSupplierAccessBasicInformation2>()
                .eq(BizSupplierAccessBasicInformation2::getSupplierEnterpriseId, id)
                .eq(BizSupplierAccessBasicInformation2::getIsDele, "0"));
        vo.setBasicInformationFlag1(count1 > 0 ? "1" : "0");
        vo.setBasicInformationFlag2(count1 > 0 ? "1" : "0");

        //人员信息
        if ("0".equals(vo.getAccessPersonnelFlag())){
            int count2 = accessEnterprisePersonnel2Manager.count(new LambdaQueryWrapper<BizSupplierAccessEnterprisePersonnel2>()
                    .eq(BizSupplierAccessEnterprisePersonnel2::getSupplierEnterpriseId, id)
                    .eq(BizSupplierAccessEnterprisePersonnel2::getIsDele, "0"));
            vo.setAccessPersonnelFlag(count2 > 0 ? "1" : "0");
        }
        //企业资质
        if ("0".equals(vo.getQualificationFlag())){
            int count3 = qualificationDatabase2Manager.count(new LambdaQueryWrapper<BizSupplierEnterpriseQualificationDatabase2>()
                    .eq(BizSupplierEnterpriseQualificationDatabase2::getSupplierEnterpriseId, id)
                    .eq(BizSupplierEnterpriseQualificationDatabase2::getIsDele, "0"));
            vo.setQualificationFlag(count3 > 0 ? "1" : "0");
        }

        //主营产品情况
        if ("0".equals(vo.getMainProductsSalesStatusFlag())){
            int count4 = mainProductsSalesStatus2Manager.count(new LambdaQueryWrapper<BizSupplierMainProductsSalesStatus2>()
                    .eq(BizSupplierMainProductsSalesStatus2::getSupplierEnterpriseId, id)
                    .eq(BizSupplierMainProductsSalesStatus2::getIsDele, "0"));
            vo.setMainProductsSalesStatusFlag(count4 > 0 ? "1" : "0");
        }

        //主营产品质量业绩
        if ("0".equals(vo.getMainProductsPerformanceFlag())){
            int count5 = mainProductsPerformance2Manager.count(new LambdaQueryWrapper<BizSupplierMainProductsPerformance2>()
                    .eq(BizSupplierMainProductsPerformance2::getSupplierEnterpriseId, id)
                    .eq(BizSupplierMainProductsPerformance2::getIsDele, "0"));
            vo.setMainProductsPerformanceFlag(count5 > 0 ? "1" : "0");
        }

        //主要原材料及供应商
        if ("0".equals(vo.getMainRawMaterialsSuppliersFlag())){
            int count6 = mainRawMaterialsSuppliers2Manager.count(new LambdaQueryWrapper<BizSupplierMainRawMaterialsSuppliers2>()
                    .eq(BizSupplierMainRawMaterialsSuppliers2::getSupplierEnterpriseId, id)
                    .eq(BizSupplierMainRawMaterialsSuppliers2::getIsDele, "0"));
            vo.setMainRawMaterialsSuppliersFlag(count6 > 0 ? "1" : "0");
        }

        //生产制造过程绩效
        if ("0".equals(vo.getProductionProcessPerformanceFlag())){
            int count7 = productionProcessPerformance2Manager.count(new LambdaQueryWrapper<BizSupplierProductionProcessPerformance2>()
                    .eq(BizSupplierProductionProcessPerformance2::getSupplierEnterpriseId, id)
                    .eq(BizSupplierProductionProcessPerformance2::getIsDele, "0"));
            vo.setProductionProcessPerformanceFlag(count7 > 0 ? "1" : "0");
        }

        //生产设备
        if ("0".equals(vo.getProductionEquipmentFlag())){
            int count8 = productionEquipment2Manager.count(new LambdaQueryWrapper<BizSupplierProductionEquipment2>()
                    .eq(BizSupplierProductionEquipment2::getSupplierEnterpriseId, id)
                    .eq(BizSupplierProductionEquipment2::getIsDele, "0"));
            vo.setProductionEquipmentFlag(count8 > 0 ? "1" : "0");
        }

        //检验设备
        if ("0".equals(vo.getInspectionEquipmentFlag())){
            int count9 = inspectionEquipment2Manager.count(new LambdaQueryWrapper<BizSupplierInspectionEquipment2>()
                    .eq(BizSupplierInspectionEquipment2::getSupplierEnterpriseId, id)
                    .eq(BizSupplierInspectionEquipment2::getIsDele, "0"));
            vo.setInspectionEquipmentFlag(count9 > 0 ? "1" : "0");
        }

        //其他特别说明
        if ("0".equals(vo.getOtherSpecialNotesFlag())){
            int count10 = otherSpecialNotes2Manager.count(new LambdaQueryWrapper<BizSupplierOtherSpecialNotes2>()
                    .eq(BizSupplierOtherSpecialNotes2::getSupplierEnterpriseId, id)
                    .eq(BizSupplierOtherSpecialNotes2::getIsDele, "0"));
            vo.setOtherSpecialNotesFlag(count10 > 0 ? "1" : "0");
        }

        return vo;
    }

    @Override
    public BizEnterpriseBusinessLicense getSupplierBasicInfo(String supplierId) {
        BizEnterpriseBusinessLicense enterpriseBusinessLicense = enterpriseBusinessLicenseManager.getOne(new LambdaQueryWrapper<BizEnterpriseBusinessLicense>()
                .eq(BizEnterpriseBusinessLicense::getEnterpriseId, supplierId)
                .eq(BizEnterpriseBusinessLicense::getIsDele, "0"));
//        if (BeanUtils.isEmpty(enterpriseBusinessLicense)){
//            throw new ApplicationException("未查询到供应商基本信息！");
//        }
        return enterpriseBusinessLicense;
    }

    @Override
    public List<BizSupplierQualificationDatabase> getQualificationByEnterpriseId(String enterpriseId, String type) {
        if (BeanUtils.isEmpty(enterpriseId)){
            return new ArrayList<>();
        }
        String currentOrgId = ContextUtil.getCurrentOrgId();
        BizSupplierAccessConfiguration accessConfiguration = accessConfigurationManager.getOne(new LambdaQueryWrapper<BizSupplierAccessConfiguration>()
                .eq(BizSupplierAccessConfiguration::getEnterpriseId, enterpriseId)
                .eq(BizSupplierAccessConfiguration::getIsDele, "0"));
        if (BeanUtils.isEmpty(accessConfiguration)){
            throw new ApplicationException("请先配置准入资质！");
        }
        String supplierAccessId = accessConfiguration.getId();
        //准入配置资质类型
        List<BizSupplierAccessQualification> accessQualificationList = qualificationManager.list(new LambdaQueryWrapper<BizSupplierAccessQualification>()
                .eq(BizSupplierAccessQualification::getSupplierAccessId, supplierAccessId)
                .eq(BizSupplierAccessQualification::getIsDele, "0"));
        Map<String, List<BizSupplierAccessQualification>> accessQualificationMap = accessQualificationList.stream()
                .collect(Collectors.groupingBy(BizSupplierAccessQualification::getRequired));
        //准入资质
        List<BizSupplierQualificationDatabase> qualificationDatabaseList = new ArrayList<>();
        //必填资质
        if ("1".equals(type)){
            //必填资质类型
            List<BizSupplierAccessQualification> required = accessQualificationMap.get("required");
            List<String> requiredCategoryCode = required.stream()
                    .map(e -> e.getQualificationCategoryCode()).collect(Collectors.toList());
            qualificationDatabaseList = qualificationDatabaseManager.listByCategoryCode(requiredCategoryCode,currentOrgId);
        }
        //选填资质
        if ("2".equals(type)){
            //选填资质类型
            List<BizSupplierAccessQualification> unnecessary = accessQualificationMap.get("unnecessary");
            List<String> unnecessaryCategoryCode = unnecessary.stream()
                    .map(e -> e.getQualificationCategoryCode()).collect(Collectors.toList());
            qualificationDatabaseList = qualificationDatabaseManager.listByCategoryCode(unnecessaryCategoryCode,currentOrgId);
        }
        //其他资质
        if ("3".equals(type)){
            qualificationDatabaseList = qualificationDatabaseManager.listByCategoryCode(null,currentOrgId);
        }
        return qualificationDatabaseList;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean audit(BizSupplierEnterpriseAccessApprovalRecord2 accessApprovalRecord2) throws InvocationTargetException, IllegalAccessException {
        String supplierEnterpriseId = accessApprovalRecord2.getSupplierEnterpriseId();
        //根据 供应商准入配置 跳过节点
        BizSupplierEnterpriseAccess enterpriseAccess = get(supplierEnterpriseId);
        String enterpriseId = enterpriseAccess.getEnterpriseId();
        String accessConfigurationId = enterpriseAccess.getAccessConfigurationId();
        BizSupplierAccessProcess accessProcess = accessProcessManager.getOne(new LambdaQueryWrapper<BizSupplierAccessProcess>()
                .eq(BizSupplierAccessProcess::getSupplierAccessId, accessConfigurationId)
                .eq(BizSupplierAccessProcess::getIsDele, "0"));
        String status = null;
        if ("1".equals(accessApprovalRecord2.getApprovalResult())){
            //基本情况审核
            if ("2".equals(accessApprovalRecord2.getStatus())){
                status = "4";
            }
            //现场评审
            if ("4".equals(accessApprovalRecord2.getStatus())){
                String userId = ContextUtil.getCurrentUserId();
                String reviewPanel = enterpriseAccess.getReviewPanel();
                String reviewPanelAudit = enterpriseAccess.getReviewPanelAudit();
                //需评审人员
                List<String> rpList = StrUtil.split(reviewPanel, ',');
                //已评审人员
                Set<String> rpaSet = StrUtil.isNotEmpty(reviewPanelAudit) ? new HashSet<>(StrUtil.split(reviewPanelAudit, ',')) : new HashSet<>();
                rpaSet.add(userId);
                //更新已评审人员
                String rpa = String.join(",", rpaSet);
                this.update(new LambdaUpdateWrapper<BizSupplierEnterpriseAccess>()
                        .eq(BizSupplierEnterpriseAccess::getId,enterpriseAccess.getId())
                        .set(BizSupplierEnterpriseAccess::getReviewPanelAudit,rpa));
                List<String> subtractReviewPanelList = CollectionUtil.subtractToList(rpList, rpaSet);
                //全部审核完
                if (CollectionUtil.isEmpty(subtractReviewPanelList)){
                    status = "5";
                    List<UserVo> userList = this.baseMapper.selectUser(rpaSet);
                    List<String> uIds = userList.stream().map(u -> u.getId()).collect(Collectors.toList());
                    List<String> accounts = userList.stream().map(u -> u.getAccount()).collect(Collectors.toList());
                    List<String> names = userList.stream().map(u -> u.getFullname()).collect(Collectors.toList());
                    accessApprovalRecord2.setApprovalId(String.join(",",uIds));
                    accessApprovalRecord2.setApprovalName(String.join(",",names));
                    accessApprovalRecord2.setApprovalAccount(String.join(",",accounts));
                }else {
                    return true;
                }
            }
            //评审报告
            if ("5".equals(accessApprovalRecord2.getStatus())){
                status = "6";
            }
            //样品试用
            if ("6".equals(accessApprovalRecord2.getStatus())){
                status = "7";
            }
        }
        if ("0".equals(accessApprovalRecord2.getApprovalResult())){
            status = accessApprovalRecord2.getStatus();
        }
//        String code = accessProcess.getCode();
//        String[] statusArr = code.split(",");
//        Set<String> set = Arrays.stream(statusArr).collect(Collectors.toSet());
//        if (!set.contains(accessApprovalRecord2.getStatus())){
//            if ("4".equals(status)){
//                accessApprovalRecord2.setStatus("6");
//            }
//        }
//        if (!set.contains(accessApprovalRecord2.getStatus())){
//            if ("6".equals(status)){
//                accessApprovalRecord2.setStatus("7");
//            }
//        }
        boolean result = update(new LambdaUpdateWrapper<BizSupplierEnterpriseAccess>()
                .set(BizSupplierEnterpriseAccess::getStatus,status)
                .eq(BizSupplierEnterpriseAccess::getId,supplierEnterpriseId)
                .eq(BizSupplierEnterpriseAccess::getIsDele,"0"));
        if (!result){
            return false;
        }
        if ("7".equals(status)){
            //保存为合格供应商
            saveEnterprise(supplierEnterpriseId,accessApprovalRecord2.getApprovalResult());
        }
        //保存审批记录
        HashMap<String, Object> map = new HashMap<>();
        map.put("SUPPLIER_ENTERPRISE_ID_", supplierEnterpriseId);
        accessApprovalRecord2.setSn(accessApprovalRecord2Manager.getNextSequence(map));
        return setApprovalLog(accessApprovalRecord2);
    }

    /**
     * 保存为合格供应商
     * @param id
     */
    private void saveEnterprise(String id,String approvalResult) throws InvocationTargetException, IllegalAccessException {
        EnterpriseDto dto = new EnterpriseDto();
        BizSupplierEnterpriseAccess supplierEnterpriseAccess = get(id);
        EnterpriseAccess2Vo info = getInfo(id);
        BeanUtils.copyNotNullProperties(dto,supplierEnterpriseAccess);
        //供应物资
        List<BizSupplierMainSupplyMaterialCategory2> mainSupplyMaterialCategory2List = info.getMaterialCategory2List();
        Set<String> cIdSet = new HashSet<>();
        Set<String> cNameSet = new HashSet<>();
        if (mainSupplyMaterialCategory2List != null && mainSupplyMaterialCategory2List.size() > 0){
            List<BizSupplierMainSupplyMaterialCategory> mainSupplyMaterialCategoryList = new ArrayList<>();
            for (BizSupplierMainSupplyMaterialCategory2 mainSupplyMaterialCategory2 : mainSupplyMaterialCategory2List) {
                BizSupplierMainSupplyMaterialCategory mainSupplyMaterialCategory = new BizSupplierMainSupplyMaterialCategory();
                BeanUtils.copyNotNullProperties(mainSupplyMaterialCategory,mainSupplyMaterialCategory2);
                mainSupplyMaterialCategory.setId(null);
                mainSupplyMaterialCategoryList.add(mainSupplyMaterialCategory);
                //供应商分类
                BizSupplierCategoryConfiguration categoryConfiguration = categoryConfigurationManager.getByCategoryId(mainSupplyMaterialCategory2.getCategoryId());
                if (BeanUtils.isNotEmpty(categoryConfiguration)){
                    cIdSet.add(categoryConfiguration.getId());
                    cNameSet.add(categoryConfiguration.getName());
                    //供应商分级
                    BizSupplierGradingConfiguration gradingConfiguration = gradingConfigurationManager.getByCategoryConfiguration(categoryConfiguration.getId());
                    if (BeanUtils.isNotEmpty(gradingConfiguration)){
                        dto.setGradingId(gradingConfiguration.getId());
                        dto.setGradingNo(gradingConfiguration.getCode());
                        dto.setGradingName(gradingConfiguration.getName());
                    }
                }

            }
            String cIds = String.join(",", cIdSet);
            String cNames = String.join(",", cNameSet);
            dto.setCatId(cIds);
            dto.setCatName(cNames);
            dto.setMaterialCategoryList(mainSupplyMaterialCategoryList);
        }

        //基本情况 企业规模
        BizSupplierAccessBasicInformation2 information2 = info.getInformation();
        if (BeanUtils.isNotEmpty(information2)){
            BizSupplierAccessBasicInformation information = new BizSupplierAccessBasicInformation();
            BeanUtils.copyNotNullProperties(information,information2);
            information.setId(null);
            dto.setInformation(information);
        }

        //企业资质
        List<BizSupplierEnterpriseQualificationDatabase2> qualification2List = new ArrayList<>();
        Map<String, List<BizSupplierEnterpriseQualificationDatabase2>> qualificationMap1 = info.getQualificationMap();
        Set<String> keySet = qualificationMap1.keySet();
        for (String key : keySet) {
            qualification2List.addAll(BeanUtils.isEmpty(qualificationMap1.get(key)) ? new ArrayList<>() : qualificationMap1.get(key));
        }

        List<BizSupplierEnterpriseQualificationDatabase> qualificationList = new ArrayList<>();
        for (BizSupplierEnterpriseQualificationDatabase2 enterpriseQualificationDatabase2 : qualification2List) {
            BizSupplierEnterpriseQualificationDatabase enterpriseQualificationDatabase = new BizSupplierEnterpriseQualificationDatabase();
            BeanUtils.copyNotNullProperties(enterpriseQualificationDatabase,enterpriseQualificationDatabase2);
            enterpriseQualificationDatabase.setId(null);
            qualificationList.add(enterpriseQualificationDatabase);
        }
        Map<String, List<BizSupplierEnterpriseQualificationDatabase>> qualificationMap = qualificationList.stream()
                .collect(Collectors.groupingBy(BizSupplierEnterpriseQualificationDatabase::getMustTransmit));
        dto.setQualificationMap(qualificationMap);

        //主营产品情况
        List<BizSupplierMainProductsSalesStatus2> salesStatus2List = info.getSalesStatus2List();
        if (salesStatus2List != null && salesStatus2List.size() > 0){
            List<BizSupplierMainProductsSalesStatus> salesStatusList = new ArrayList<>();
            for (BizSupplierMainProductsSalesStatus2 mainProductsSalesStatus2 : salesStatus2List) {
                BizSupplierMainProductsSalesStatus mainProductsSalesStatus = new BizSupplierMainProductsSalesStatus();
                BeanUtils.copyNotNullProperties(mainProductsSalesStatus,mainProductsSalesStatus2);
                mainProductsSalesStatus.setId(null);
                salesStatusList.add(mainProductsSalesStatus);
            }
            dto.setSalesStatusList(salesStatusList);
        }

        //主营产品质量业绩
        MainProductsPerformance2Vo performance2 = info.getMainProductsPerformance();
        if (BeanUtils.isNotEmpty(performance2)){
            MainProductsPerformanceDto performanceDto = new MainProductsPerformanceDto();
            BeanUtils.copyNotNullProperties(performanceDto,performance2);
            //附件
            List<DefaultFile> defaultFiles = performance2.getFiles();
            performanceDto.setFiles(defaultFiles);
            performanceDto.setId(null);
            List<BizSupplierMainProductsQualityPerformance2> qualityPerformance2List = performance2.getQualityPerformance2List();
            List<BizSupplierMainProductsQualityPerformance> qualityPerformanceList = new ArrayList<>();
            for (BizSupplierMainProductsQualityPerformance2 mainProductsQualityPerformance2 : qualityPerformance2List) {
                BizSupplierMainProductsQualityPerformance mainProductsQualityPerformance = new BizSupplierMainProductsQualityPerformance();
                BeanUtils.copyNotNullProperties(mainProductsQualityPerformance,mainProductsQualityPerformance2);
                mainProductsQualityPerformance.setId(null);
                qualityPerformanceList.add(mainProductsQualityPerformance);
            }
            performanceDto.setQualityPerformanceList(qualityPerformanceList);

            List<BizSupplierMainProductsPerformanceCustomerComplaints2> customerComplaints2List = performance2.getCustomerComplaints2List();
            List<BizSupplierMainProductsPerformanceCustomerComplaints> customerComplaintsList = new ArrayList<>();
            for (BizSupplierMainProductsPerformanceCustomerComplaints2 customerComplaints2 : customerComplaints2List) {
                BizSupplierMainProductsPerformanceCustomerComplaints customerComplaints = new BizSupplierMainProductsPerformanceCustomerComplaints();
                BeanUtils.copyNotNullProperties(customerComplaints,customerComplaints2);
                customerComplaints.setId(null);
                customerComplaintsList.add(customerComplaints);
            }
            performanceDto.setCustomerComplaintsList(customerComplaintsList);
            dto.setMainProductsPerformance(performanceDto);
        }

        //主要原材料及供应商
        List<BizSupplierMainRawMaterialsSuppliers2> mainRawMaterialsSuppliers2List = info.getRawMaterialsSuppliersList();
        if (mainRawMaterialsSuppliers2List != null && mainRawMaterialsSuppliers2List.size() > 0){
            List<BizSupplierMainRawMaterialsSuppliers> mainRawMaterialsSuppliersList = new ArrayList<>();
            for (BizSupplierMainRawMaterialsSuppliers2 mainRawMaterialsSuppliers2 : mainRawMaterialsSuppliers2List) {
                BizSupplierMainRawMaterialsSuppliers mainRawMaterialsSuppliers = new BizSupplierMainRawMaterialsSuppliers();
                BeanUtils.copyNotNullProperties(mainRawMaterialsSuppliers,mainRawMaterialsSuppliers2);
                mainRawMaterialsSuppliers.setId(null);
                mainRawMaterialsSuppliersList.add(mainRawMaterialsSuppliers);
            }
            dto.setRawMaterialsSuppliersList(mainRawMaterialsSuppliersList);
        }

        //生产制造过程绩效
        BizSupplierProductionProcessPerformance2Vo processPerformance2 = info.getProcessPerformance();
        if (BeanUtils.isNotEmpty(processPerformance2)){
            BizSupplierProductionProcessPerformanceDto processPerformanceDto = new BizSupplierProductionProcessPerformanceDto();
            BeanUtils.copyNotNullProperties(processPerformanceDto,processPerformance2);
            //附件
            List<DefaultFile> files = processPerformance2.getFiles();
            processPerformanceDto.setFiles(files);
            processPerformanceDto.setId(null);
            if (BeanUtils.isNotEmpty(processPerformance2)){
                List<BizSupplierProductionProcessFlow2> productionProcessFlow2List = processPerformance2.getProcessFlow2List();
                List<BizSupplierProductionProcessFlow> productionProcessFlowList = new ArrayList<>();
                for (BizSupplierProductionProcessFlow2 productionProcessFlow2 : productionProcessFlow2List) {
                    BizSupplierProductionProcessFlow productionProcessFlow = new BizSupplierProductionProcessFlow();
                    BeanUtils.copyNotNullProperties(productionProcessFlow,productionProcessFlow2);
                    productionProcessFlow.setId(null);
                    productionProcessFlowList.add(productionProcessFlow);
                }
                processPerformanceDto.setProcessFlowList(productionProcessFlowList);
            }
            dto.setProcessPerformance(processPerformanceDto);
        }

        //生产设备
        List<BizSupplierProductionEquipment2> productionEquipment2List = info.getProductionEquipment2List();
        if (productionEquipment2List != null && productionEquipment2List.size() > 0){
            List<BizSupplierProductionEquipment> productionEquipmentList = new ArrayList<>();
            for (BizSupplierProductionEquipment2 productionEquipment2 : productionEquipment2List) {
                BizSupplierProductionEquipment productionEquipment = new BizSupplierProductionEquipment();
                BeanUtils.copyNotNullProperties(productionEquipment,productionEquipment2);
                productionEquipmentList.add(productionEquipment);
            }
            dto.setProductionEquipmentList(productionEquipmentList);
            //附件
            List<DefaultFile> productionEquipmentFiles = info.getProductionEquipmentFiles();
            dto.setProductionEquipmentFiles(productionEquipmentFiles);
        }

        //检验设备
        List<BizSupplierInspectionEquipment2> inspectionEquipment2List = info.getInspectionEquipment2List();
        if (inspectionEquipment2List != null && inspectionEquipment2List.size() > 0){
            List<BizSupplierInspectionEquipment> inspectionEquipmentList = new ArrayList<>();
            for (BizSupplierInspectionEquipment2 inspectionEquipment2 : inspectionEquipment2List) {
                BizSupplierInspectionEquipment inspectionEquipment = new BizSupplierInspectionEquipment();
                BeanUtils.copyNotNullProperties(inspectionEquipment,inspectionEquipment2);
                inspectionEquipmentList.add(inspectionEquipment);
            }
            dto.setInspectionEquipmentList(inspectionEquipmentList);
            //附件
            List<DefaultFile> inspectionEquipmentFiles = info.getInspectionEquipmentFiles();
            dto.setInspectionEquipmentFiles(inspectionEquipmentFiles);
        }

        //其他特别说明
        BizSupplierOtherSpecialNotes2 otherSpecialNotes2 = info.getOtherSpecialNotes();
        if (BeanUtils.isNotEmpty(otherSpecialNotes2)){
            BizSupplierOtherSpecialNotes otherSpecialNotes = new BizSupplierOtherSpecialNotes();
            BeanUtils.copyNotNullProperties(otherSpecialNotes,otherSpecialNotes2);
            //附件
            List<DefaultFile> files = otherSpecialNotes2.getFiles();
            otherSpecialNotes.setFiles(files);
            otherSpecialNotes.setId(null);
            dto.setOtherSpecialNotes(otherSpecialNotes);
        }

        //现场评审
        Map<String, List<BizSupplierReviewRatingDetails2Vo>> reviewRatingDetails2Map = info.getReviewRatingDetails2Map();
        if (reviewRatingDetails2Map != null && reviewRatingDetails2Map.size() > 0){
            List<BizSupplierReviewRatingDetails2Vo> reviewRatingDetails2List = new ArrayList<>();
            Set<String> rrdKey = reviewRatingDetails2Map.keySet();
            for (String key : rrdKey) {
                reviewRatingDetails2List.addAll(BeanUtils.isEmpty(reviewRatingDetails2Map.get(key)) ? new ArrayList<>() : reviewRatingDetails2Map.get(key));
            }
            List<BizSupplierReviewRatingDetailsDto> reviewRatingDetailsList = new ArrayList<>();
            for (BizSupplierReviewRatingDetails2Vo reviewRatingDetails2Dto : reviewRatingDetails2List) {
                BizSupplierReviewRatingDetailsDto reviewRatingDetailsDto = new BizSupplierReviewRatingDetailsDto();
                BeanUtils.copyNotNullProperties(reviewRatingDetailsDto,reviewRatingDetails2Dto);
                reviewRatingDetailsDto.setId(null);
                List<BizSupplierReviewRatingPanel2> panel2List = reviewRatingDetails2Dto.getPanelList();
                List<BizSupplierReviewRatingPanel> panelList = new ArrayList<>();
                for (BizSupplierReviewRatingPanel2 panel2 : panel2List) {
                    BizSupplierReviewRatingPanel panel = new BizSupplierReviewRatingPanel();
                    BeanUtils.copyNotNullProperties(panel,panel2);
                    panel.setId(null);
                    panelList.add(panel);
                }
                reviewRatingDetailsDto.setPanelList(panelList);
                reviewRatingDetailsList.add(reviewRatingDetailsDto);
            }
            Map<String, List<BizSupplierReviewRatingDetailsDto>> reviewRatingDetailsMap = reviewRatingDetailsList.stream()
                    .collect(Collectors.groupingBy(BizSupplierReviewRatingDetailsDto::getClassificationName));
            dto.setReviewRatingDetailsMap(reviewRatingDetailsMap);
        }

        //评定报告
        BizSupplierReviewReport2Vo reviewReport2 = info.getReviewReport();
        if (BeanUtils.isNotEmpty(reviewReport2)){
            BizSupplierReviewReportDto reviewReportDto = new BizSupplierReviewReportDto();
            BeanUtils.copyNotNullProperties(reviewReportDto,reviewReport2);
            reviewReportDto.setId(null);
            if (BeanUtils.isNotEmpty(reviewReport2)){
                List<BizSupplierReviewReportPanel2> panel2List = reviewReport2.getPanel2List();
                List<BizSupplierReviewReportPanel> panelList = new ArrayList<>();
                for (BizSupplierReviewReportPanel2 panel2 : panel2List) {
                    BizSupplierReviewReportPanel panel = new BizSupplierReviewReportPanel();
                    BeanUtils.copyNotNullProperties(panel,panel2);
                    panel.setId(null);
                    panelList.add(panel);
                }
                reviewReportDto.setPanelList(panelList);
            }
            dto.setReviewReport(reviewReportDto);
        }

        //试生产评审
        BizSupplierReviewTrialReport2Vo reviewTrialReport2 = info.getReviewTrialReport();
        if (BeanUtils.isNotEmpty(reviewTrialReport2)){
            BizSupplierReviewTrialReportDto reviewTrialReportDto = new BizSupplierReviewTrialReportDto();
            BeanUtils.copyNotNullProperties(reviewTrialReportDto,reviewTrialReport2);
            reviewTrialReportDto.setId(null);
            List<BizSupplierReviewTrialReportPanel2> reviewTrialReportPanel2List = reviewTrialReport2.getPanel2List();
            List<BizSupplierReviewTrialReportPanel> reviewTrialReportPanelList = new ArrayList<>();
            for (BizSupplierReviewTrialReportPanel2 trialReportPanel2 : reviewTrialReportPanel2List) {
                BizSupplierReviewTrialReportPanel trialReportPanel = new BizSupplierReviewTrialReportPanel();
                BeanUtils.copyNotNullProperties(trialReportPanel,trialReportPanel2);
                trialReportPanel.setId(null);
                reviewTrialReportPanelList.add(trialReportPanel);
            }
            reviewTrialReportDto.setPanelList(reviewTrialReportPanelList);
            dto.setReviewTrialReport(reviewTrialReportDto);
        }
        //人员信息
        List<BizSupplierAccessEnterprisePersonnel2> personnel2List = info.getEnterprisePersonnelList();
        if (personnel2List != null && personnel2List.size() > 0){
            List<BizSupplierAccessEnterprisePersonnel> personnelList = new ArrayList<>();
            for (BizSupplierAccessEnterprisePersonnel2 personnel2 : personnel2List) {
                BizSupplierAccessEnterprisePersonnel personnel = new BizSupplierAccessEnterprisePersonnel();
                BeanUtils.copyNotNullProperties(personnel,personnel2);
                personnel.setId(null);
                personnelList.add(personnel);
            }
            dto.setEnterprisePersonnelList(personnelList);
        }
//        if (true){
//            return;
//        }
        //保存合格供应商
        dto.setId(null);
        dto.setSupplierEnterpriseAccessId(id);
        dto.setType("1");
        String totalAmount = selectTotalAmount(dto.getSupplierId());
        dto.setTotalAmount(totalAmount);
        dto.setSelectionDate(LocalDateTime.now());
        supplierEnterpriseManager.saveFullModel(dto);
    }

    @Override
    public String selectTotalAmount(String supplierId){
        return baseMapper.selectTotalAmount(supplierId);
    }

    /**
     * 保存审批记录
     * @param approvalRecord2
     * @return
     */
    public Boolean setApprovalLog(BizSupplierEnterpriseAccessApprovalRecord2 approvalRecord2){
        String jobNum = generate10CharUUID();
        String currentUserId = ContextUtil.getCurrentUserId();
        String currentUserAccount = ContextUtil.getCurrentUserAccount();
        String currentUserName = ContextUtil.getCurrentUserName();
        String currentOrgId = ContextUtil.getCurrentOrgId();
        String currentOrgCode = ContextUtil.getCurrentOrgCode();
        String currentOrgName = ContextUtil.getCurrentOrgName();
        LocalDateTime now = LocalDateTime.now();
        approvalRecord2.setJobNum(jobNum);
        if ("1".equals(approvalRecord2.getStatus())){
            approvalRecord2.setFirstNode("1");
        } else if ("7".equals(approvalRecord2.getStatus())) {
            approvalRecord2.setTailNode("1");
        }else {
            approvalRecord2.setFirstNode("0");
            approvalRecord2.setTailNode("0");
        }
        if (BeanUtils.isEmpty(approvalRecord2.getApprovalId())){
            approvalRecord2.setApprovalId(currentUserId);
            approvalRecord2.setApprovalAccount(currentUserAccount);
            approvalRecord2.setApprovalName(currentUserName);
        }
        approvalRecord2.setApprovalOrgId(currentOrgId);
        approvalRecord2.setApprovalOrgName(currentOrgName);
        approvalRecord2.setApprovalOrgCode(currentOrgCode);
        approvalRecord2.setApprovalDate(now);
        return accessApprovalRecord2Manager.save(approvalRecord2);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean submit(String id) {
        LocalDateTime now = LocalDateTime.now();
        boolean result = update(new LambdaUpdateWrapper<BizSupplierEnterpriseAccess>()
                .set(BizSupplierEnterpriseAccess::getStatus,"2")
                .set(BizSupplierEnterpriseAccess::getSubmitDate,now)
                .eq(BizSupplierEnterpriseAccess::getId,id)
                .eq(BizSupplierEnterpriseAccess::getIsDele,"0"));
        if (!result){
            return false;
        }
        BizSupplierEnterpriseAccessApprovalRecord2 approvalRecord2 = new BizSupplierEnterpriseAccessApprovalRecord2();
        String jobNum = generate10CharUUID();
        String currentUserId = ContextUtil.getCurrentUserId();
        String currentUserAccount = ContextUtil.getCurrentUserAccount();
        String currentUserName = ContextUtil.getCurrentUserName();
        String currentOrgId = ContextUtil.getCurrentOrgId();
        String currentOrgCode = ContextUtil.getCurrentOrgCode();
        String currentOrgName = ContextUtil.getCurrentOrgName();
        approvalRecord2.setJobNum(jobNum);
        approvalRecord2.setSupplierEnterpriseId(id);
        approvalRecord2.setStatus("1");
        approvalRecord2.setFirstNode("1");
        approvalRecord2.setTailNode("0");
        approvalRecord2.setApprovalId(currentUserId);
        approvalRecord2.setApprovalAccount(currentUserAccount);
        approvalRecord2.setApprovalName(currentUserName);
        approvalRecord2.setApprovalOrgId(currentOrgId);
        approvalRecord2.setApprovalOrgName(currentOrgName);
        approvalRecord2.setApprovalOrgCode(currentOrgCode);
        approvalRecord2.setApprovalDate(now);
        HashMap<String, Object> map = new HashMap<>();
        map.put("SUPPLIER_ENTERPRISE_ID_", id);
        approvalRecord2.setSn(accessApprovalRecord2Manager.getNextSequence(map));
        return accessApprovalRecord2Manager.save(approvalRecord2);
    }

    @Override
    public List<BizSupplierEnterpriseAccessApprovalRecord2> queryApprovalLogs(String id) {
        BizSupplierEnterpriseAccess enterpriseAccess = get(id);
        String status = enterpriseAccess.getStatus();
        List<BizSupplierEnterpriseAccessApprovalRecord2> logs = accessApprovalRecord2Manager.list(new LambdaQueryWrapper<BizSupplierEnterpriseAccessApprovalRecord2>()
                .eq(BizSupplierEnterpriseAccessApprovalRecord2::getSupplierEnterpriseId, id)
                .eq(BizSupplierEnterpriseAccessApprovalRecord2::getIsDele, "0"));
        BizSupplierEnterpriseAccessApprovalRecord2 log = new BizSupplierEnterpriseAccessApprovalRecord2();
        logs.stream().sorted(Comparator.comparing(BizSupplierEnterpriseAccessApprovalRecord2::getSn)).collect(Collectors.toList());
        log.setStatus(status);
        logs.add(log);
        return logs;
    }

    @Override
    public List<BizSupplierReviewConfigurationVo> getReviewConfiguration(String id) {
        BizSupplierEnterpriseAccess enterpriseAccess = get(id);
//        BizEnterprise enterprise = enterpriseManager.get(enterpriseAccess.getEnterpriseId());
//        String orgId = enterprise.getOrgId();
        List<BizSupplierReviewConfiguration> reviewConfigurationList = reviewConfigurationManager.list(new LambdaQueryWrapper<BizSupplierReviewConfiguration>()
                .eq(BizSupplierReviewConfiguration::getEnterpriseId, enterpriseAccess.getEnterpriseId())
                .eq(BizSupplierReviewConfiguration::getIsDele, "0"));
        List<BizSupplierReviewConfigurationVo> voList = new ArrayList<>();
        for (BizSupplierReviewConfiguration reviewConfiguration : reviewConfigurationList) {
            BizSupplierReviewConfigurationVo vo = new BizSupplierReviewConfigurationVo();
            vo.copy(reviewConfiguration);
            List<BizSupplierReviewConfigurationDetails> reviewConfigurationDetailsList = reviewConfigurationDetailsManager.list(new LambdaQueryWrapper<BizSupplierReviewConfigurationDetails>()
                    .eq(BizSupplierReviewConfigurationDetails::getReviewConfigurationId, reviewConfiguration.getId())
                    .eq(BizSupplierReviewConfigurationDetails::getIsDele, "0"));
            List<BizSupplierReviewConfigurationDetailsVo> detailsVoList = new ArrayList<>();
            reviewConfigurationDetailsList.forEach(d -> {
                BizSupplierReviewConfigurationDetailsVo detailsVo = new BizSupplierReviewConfigurationDetailsVo();
                detailsVo.copy(d);
                List<BizSupplierReviewConfigurationDetailsPanel> panelList = reviewConfigurationDetailsPanelManager.list(new LambdaQueryWrapper<BizSupplierReviewConfigurationDetailsPanel>()
                        .eq(BizSupplierReviewConfigurationDetailsPanel::getReviewConfigurationDetailsId, d.getId())
                        .eq(BizSupplierReviewConfigurationDetailsPanel::getIsDele, "0"));
                detailsVo.setPanelList(panelList);
                detailsVoList.add(detailsVo);
            });
            Map<String, List<BizSupplierReviewConfigurationDetailsVo>> detailMap = detailsVoList.stream()
                    .collect(Collectors.groupingBy(BizSupplierReviewConfigurationDetailsVo::getClassificationName));
            vo.setDetailsMap(detailMap);
            voList.add(vo);
        }
        return voList;
    }

    @Override
    public List<BizSupplierReviewReportPanel2> getReportPanel(String id) {
        List<BizSupplierReviewRatingDetails2Vo> reviewRatingDetails2List = reviewRatingDetails2Manager.queryWithPanel(id,null);
        Set<String> set = new HashSet<>();
        List<BizSupplierReviewReportPanel2> reviewReportPanel2sList = new ArrayList<>();
        for (BizSupplierReviewRatingDetails2Vo ratingDetails2 : reviewRatingDetails2List) {
            List<BizSupplierReviewRatingPanel2> panelList = ratingDetails2.getPanelList();
            for (BizSupplierReviewRatingPanel2 ratingPanel2 : panelList) {
                if (!set.contains(ratingPanel2.getRatingId())){
                    BizSupplierReviewReportPanel2 reportPanel2 = new BizSupplierReviewReportPanel2();
                    reportPanel2.setOperationRatingId(ratingPanel2.getRatingId());
                    reportPanel2.setOperationRatingAccount(ratingPanel2.getRatingAccount());
                    reportPanel2.setOperationRatingName(ratingPanel2.getRatingName());
                    set.add(ratingPanel2.getRatingId());
                    reviewReportPanel2sList.add(reportPanel2);
                }
            }
        }
        return reviewReportPanel2sList;
    }

    @Override
    public List<BizSupplierReviewTrialReportPanel2> getTrialReportPanel(String id) {
        List<BizSupplierReviewRatingDetails2Vo> reviewRatingDetails2List = reviewRatingDetails2Manager.queryWithPanel(id,null);
        Set<String> set = new HashSet<>();
        List<BizSupplierReviewTrialReportPanel2> reviewTrialReportPanel2List = new ArrayList<>();
        for (BizSupplierReviewRatingDetails2Vo ratingDetails2 : reviewRatingDetails2List) {
            List<BizSupplierReviewRatingPanel2> panelList = ratingDetails2.getPanelList();
            for (BizSupplierReviewRatingPanel2 ratingPanel2 : panelList) {
                if (!set.contains(ratingPanel2.getRatingId())){
                    BizSupplierReviewTrialReportPanel2 trialReportPanel2 = new BizSupplierReviewTrialReportPanel2();
                    trialReportPanel2.setOperationRatingId(ratingPanel2.getRatingId());
                    trialReportPanel2.setOperationRatingAccount(ratingPanel2.getRatingAccount());
                    trialReportPanel2.setOperationRatingName(ratingPanel2.getRatingName());
                    set.add(ratingPanel2.getRatingId());
                    reviewTrialReportPanel2List.add(trialReportPanel2);
                }
            }
        }
        return reviewTrialReportPanel2List;
    }

    @Override
    public String getEnterpriseScore(String id) {
        List<BizSupplierReviewRatingDetails2> ratingDetails2List = reviewRatingDetails2Manager.list(new LambdaQueryWrapper<BizSupplierReviewRatingDetails2>()
                .eq(BizSupplierReviewRatingDetails2::getSupplierEnterpriseId, id)
                .eq(BizSupplierReviewRatingDetails2::getIsDele, "0"));
        double result = 0;
        for (BizSupplierReviewRatingDetails2 details2 : ratingDetails2List) {
//            List<BizSupplierReviewRatingPanel2> panel2List = reviewRatingPanel2Manager.list(new LambdaQueryWrapper<BizSupplierReviewRatingPanel2>()
//                    .eq(BizSupplierReviewRatingPanel2::getReviewRatingDetailsId, details2.getId()));
//            Integer pSum = 0;
//            for (BizSupplierReviewRatingPanel2 panel2 : panel2List) {
//                pSum += panel2.getScore();
//            }
//            Integer score = pSum/panel2List.size();
//            Float weight = details2.getWeight();
//            result += (score * weight)/100;
            result += details2.getOperationScore().doubleValue();
        }
        return String.format("%.2f",result);
    }

    @Override
    public List<BizSupplierQualificationDatabase> getQualification(String categoryId, String type) {
        String currentOrgId = ContextUtil.getCurrentOrgId();
        BizSupplierAccessConfigurationMaterialCategory configurationMaterialCategory = accessConfigurationMaterialCategoryManager.getOne(new LambdaQueryWrapper<BizSupplierAccessConfigurationMaterialCategory>()
                .eq(BizSupplierAccessConfigurationMaterialCategory::getCategoryId, categoryId)
                .eq(BizSupplierAccessConfigurationMaterialCategory::getIsDele, "0"));
        if (BeanUtils.isEmpty(configurationMaterialCategory)){
            throw new ApplicationException("根据供应物资未查询到准入配置模板！");
        }
        BizSupplierAccessConfiguration accessConfiguration = accessConfigurationManager.get(configurationMaterialCategory.getSupplierAccessId());
        String supplierAccessId = accessConfiguration.getId();
        //准入配置资质类型
        List<BizSupplierAccessQualification> accessQualificationList = qualificationManager.list(new LambdaQueryWrapper<BizSupplierAccessQualification>()
                .eq(BizSupplierAccessQualification::getSupplierAccessId, supplierAccessId)
                .eq(BizSupplierAccessQualification::getIsDele, "0"));
        Map<String, List<BizSupplierAccessQualification>> accessQualificationMap = accessQualificationList.stream()
                .collect(Collectors.groupingBy(BizSupplierAccessQualification::getRequired));
        //准入资质
        List<BizSupplierQualificationDatabase> qualificationDatabaseList = new ArrayList<>();
        //必填资质
        if ("1".equals(type)){
            //必填资质类型
            List<BizSupplierAccessQualification> required = accessQualificationMap.get("required");
            List<String> requiredCategoryCode = required.stream()
                    .map(e -> e.getQualificationCategoryCode()).collect(Collectors.toList());
            qualificationDatabaseList = qualificationDatabaseManager.listByCategoryCode(requiredCategoryCode,currentOrgId);
            if (qualificationDatabaseList != null && qualificationDatabaseList.size() > 0){
                Set<String> catCodeSet = qualificationDatabaseList.stream().map(q -> q.getQualificationCategoryCode()).collect(Collectors.toSet());
                for (String s : catCodeSet) {
                    requiredCategoryCode.remove(s);
                }
            }
            if (requiredCategoryCode != null && requiredCategoryCode.size() > 0){
                for (String code : requiredCategoryCode) {
                    BizSupplierQualificationCategory category = qualificationCategoryManager.getOne(new LambdaQueryWrapper<BizSupplierQualificationCategory>()
                            .eq(BizSupplierQualificationCategory::getQualificationCategoryCode, code));
                    BizSupplierQualificationDatabase qualificationDatabase = new BizSupplierQualificationDatabase();
                    qualificationDatabase.setQualificationCategoryName(category.getQualificationCategoryName());
                    qualificationDatabaseList.add(qualificationDatabase);
                }
            }
        }
        //代理资质
        if ("2".equals(type)){
            List<BizSupplierQualificationCategory> dlCategory = qualificationCategoryManager.list(new LambdaQueryWrapper<BizSupplierQualificationCategory>()
                    .eq(BizSupplierQualificationCategory::getQualificationCategoryName, "代理资质")
                    .eq(BizSupplierQualificationCategory::getIsDele, "0"));
            List<String> dlCategoryCode = new ArrayList<>();
            for (BizSupplierQualificationCategory category : dlCategory) {
                dlCategoryCode.add(category.getQualificationCategoryCode());
            }
            qualificationDatabaseList = qualificationDatabaseManager.listByCategoryCode(dlCategoryCode,currentOrgId);
        }
        return qualificationDatabaseList;
    }

    @Override
    public List<BizEnterprise> getAffiliatedEnterprise(String[] phones,String supplierId) {
        List<BizEnterprise> enterpriseList = new ArrayList<>();
        Set<String> set = new HashSet<>();
        for (String phone : phones) {
            List<BizEnterprisePersonnel> personnelList = enterprisePersonnelManager.list(new LambdaQueryWrapper<BizEnterprisePersonnel>()
                    .eq(BizEnterprisePersonnel::getMobile, phone));
            if (BeanUtils.isNotEmpty(personnelList)){
                BizEnterprisePersonnel personnel = personnelList.get(0);
                BizEnterprise enterprise = enterpriseManager.getOne(new LambdaQueryWrapper<BizEnterprise>()
                        .eq(BizEnterprise::getOrgId, personnel.getEnterpriseId())
                        .ne(BizEnterprise::getOrgId,supplierId)
                        .eq(BizEnterprise::getIsDele, "0"));
                if (BeanUtils.isEmpty(enterprise)){
                    continue;
                }
                if (set.contains(enterprise.getId())){
                    continue;
                }
                set.add(enterprise.getId());
                enterpriseList.add(enterprise);
            }
        }
        return enterpriseList;
    }

    @Override
    public List<BizSupplierAccessEnterprisePersonnel2> getEnterprisePersonnel(String supplierId) throws InvocationTargetException, IllegalAccessException {
        List<BizEnterprisePersonnel> enterprisePersonnelList = enterprisePersonnelManager.list(new LambdaQueryWrapper<BizEnterprisePersonnel>()
                .eq(BizEnterprisePersonnel::getEnterpriseId, supplierId)
                .eq(BizEnterprisePersonnel::getIsDele, "0"));
        List<BizSupplierAccessEnterprisePersonnel2> accessEnterprisePersonnel2List = new ArrayList<>();
        for (BizEnterprisePersonnel enterprisePersonnel : enterprisePersonnelList) {
            BizSupplierAccessEnterprisePersonnel2 accessEnterprisePersonnel2 = new BizSupplierAccessEnterprisePersonnel2();
            BeanUtils.copyNotNullProperties(accessEnterprisePersonnel2,enterprisePersonnel);
            accessEnterprisePersonnel2List.add(accessEnterprisePersonnel2);
        }
        return accessEnterprisePersonnel2List;
    }

    @Override
    public BizSupplierAccessConfiguration getAccessConfiguration(String categoryId) {
        BizSupplierAccessConfigurationMaterialCategory configurationMaterialCategory = accessConfigurationMaterialCategoryManager.getOne(new LambdaQueryWrapper<BizSupplierAccessConfigurationMaterialCategory>()
                .eq(BizSupplierAccessConfigurationMaterialCategory::getCategoryId, categoryId)
                .eq(BizSupplierAccessConfigurationMaterialCategory::getIsDele, "0"));
        if (BeanUtils.isEmpty(configurationMaterialCategory)){
            throw new ApplicationException("根据供应物资未查询到准入配置模板！");
        }
        BizSupplierAccessConfiguration accessConfiguration = accessConfigurationManager.get(configurationMaterialCategory.getSupplierAccessId());
        return accessConfiguration;
    }

    @Override
    public BizEnterprise getOwnerEnterprise() {
        String currentOrgId = ContextUtil.getCurrentOrgId();
        BizEnterprise enterprise = enterpriseManager.getOne(new LambdaQueryWrapper<BizEnterprise>()
                .eq(BizEnterprise::getOrgId, currentOrgId)
                .eq(BizEnterprise::getIsDele, "0"));
        return enterprise;
    }

    private FillingProgressVo createMenu(String categoryId){
        FillingProgressVo vo = new FillingProgressVo();
        BizSupplierAccessConfiguration accessConfiguration = getAccessConfiguration(categoryId);
        BizSupplierAccessBasic accessBasic = accessBasicManager.getOne(new LambdaQueryWrapper<BizSupplierAccessBasic>()
                .eq(BizSupplierAccessBasic::getSupplierAccessId, accessConfiguration.getId())
                .eq(BizSupplierAccessBasic::getIsDele, "0"));
        String code = accessBasic.getCode();
        List<String> modelCode = Arrays.stream(code.split(",")).collect(Collectors.toList());
        //基本情况
        if (modelCode.contains("1")){
            vo.setBasicInformationFlag1("0");
        }
        //人员信息
        if (modelCode.contains("2")){
            vo.setAccessPersonnelFlag("0");
        }
        //企业规模
        if (modelCode.contains("3")){
            vo.setBasicInformationFlag2("0");
        }
        //企业资质
        if (modelCode.contains("4")){
            vo.setQualificationFlag("0");
        }
        //主营产品情况
        if (modelCode.contains("5")){
            vo.setMainProductsSalesStatusFlag("0");
        }
        //主营产品质量业绩
        if (modelCode.contains("6")){
            vo.setMainProductsPerformanceFlag("0");
        }
        //主要原材料及供应商
        if (modelCode.contains("7")){
            vo.setMainRawMaterialsSuppliersFlag("0");
        }
        //生产过程绩效
        if (modelCode.contains("8")){
            vo.setProductionProcessPerformanceFlag("0");
        }
        //主要生产设备
        if (modelCode.contains("9")){
            vo.setProductionEquipmentFlag("0");
        }
        //主要检验设备
        if (modelCode.contains("10")){
            vo.setInspectionEquipmentFlag("0");
        }
        //其他特别说明
        if (modelCode.contains("11")){
            vo.setOtherSpecialNotesFlag("0");
        }
        return vo;
    }

    @Override
    public FillingProgressVo getMenu(String categoryId,String id) {
        FillingProgressVo vo = createMenu(categoryId);
        if (BeanUtils.isNotEmpty(id)){
            vo.setEnterpriseAccessFlag("1");
            //基本情况 企业规模
            int count1 = information2Manager.count(new LambdaQueryWrapper<BizSupplierAccessBasicInformation2>()
                    .eq(BizSupplierAccessBasicInformation2::getSupplierEnterpriseId, id)
                    .eq(BizSupplierAccessBasicInformation2::getIsDele, "0"));
            vo.setBasicInformationFlag1(count1 > 0 ? "1" : "0");
            vo.setBasicInformationFlag2(count1 > 0 ? "1" : "0");

            //人员信息
            if ("0".equals(vo.getAccessPersonnelFlag())){
                int count2 = accessEnterprisePersonnel2Manager.count(new LambdaQueryWrapper<BizSupplierAccessEnterprisePersonnel2>()
                        .eq(BizSupplierAccessEnterprisePersonnel2::getSupplierEnterpriseId, id)
                        .eq(BizSupplierAccessEnterprisePersonnel2::getIsDele, "0"));
                vo.setAccessPersonnelFlag(count2 > 0 ? "1" : "0");
            }
            //企业资质
            if ("0".equals(vo.getQualificationFlag())){
                int count3 = qualificationDatabase2Manager.count(new LambdaQueryWrapper<BizSupplierEnterpriseQualificationDatabase2>()
                        .eq(BizSupplierEnterpriseQualificationDatabase2::getSupplierEnterpriseId, id)
                        .eq(BizSupplierEnterpriseQualificationDatabase2::getIsDele, "0"));
                vo.setQualificationFlag(count3 > 0 ? "1" : "0");
            }

            //主营产品情况
            if ("0".equals(vo.getMainProductsSalesStatusFlag())){
                int count4 = mainProductsSalesStatus2Manager.count(new LambdaQueryWrapper<BizSupplierMainProductsSalesStatus2>()
                        .eq(BizSupplierMainProductsSalesStatus2::getSupplierEnterpriseId, id)
                        .eq(BizSupplierMainProductsSalesStatus2::getIsDele, "0"));
                vo.setMainProductsSalesStatusFlag(count4 > 0 ? "1" : "0");
            }

            //主营产品质量业绩
            if ("0".equals(vo.getMainProductsPerformanceFlag())){
                int count5 = mainProductsPerformance2Manager.count(new LambdaQueryWrapper<BizSupplierMainProductsPerformance2>()
                        .eq(BizSupplierMainProductsPerformance2::getSupplierEnterpriseId, id)
                        .eq(BizSupplierMainProductsPerformance2::getIsDele, "0"));
                vo.setMainProductsPerformanceFlag(count5 > 0 ? "1" : "0");
            }

            //主要原材料及供应商
            if ("0".equals(vo.getMainRawMaterialsSuppliersFlag())){
                int count6 = mainRawMaterialsSuppliers2Manager.count(new LambdaQueryWrapper<BizSupplierMainRawMaterialsSuppliers2>()
                        .eq(BizSupplierMainRawMaterialsSuppliers2::getSupplierEnterpriseId, id)
                        .eq(BizSupplierMainRawMaterialsSuppliers2::getIsDele, "0"));
                vo.setMainRawMaterialsSuppliersFlag(count6 > 0 ? "1" : "0");
            }

            //生产制造过程绩效
            if ("0".equals(vo.getProductionProcessPerformanceFlag())){
                int count7 = productionProcessPerformance2Manager.count(new LambdaQueryWrapper<BizSupplierProductionProcessPerformance2>()
                        .eq(BizSupplierProductionProcessPerformance2::getSupplierEnterpriseId, id)
                        .eq(BizSupplierProductionProcessPerformance2::getIsDele, "0"));
                vo.setProductionProcessPerformanceFlag(count7 > 0 ? "1" : "0");
            }

            //生产设备
            if ("0".equals(vo.getProductionEquipmentFlag())){
                int count8 = productionEquipment2Manager.count(new LambdaQueryWrapper<BizSupplierProductionEquipment2>()
                        .eq(BizSupplierProductionEquipment2::getSupplierEnterpriseId, id)
                        .eq(BizSupplierProductionEquipment2::getIsDele, "0"));
                vo.setProductionEquipmentFlag(count8 > 0 ? "1" : "0");
            }

            //检验设备
            if ("0".equals(vo.getInspectionEquipmentFlag())){
                int count9 = inspectionEquipment2Manager.count(new LambdaQueryWrapper<BizSupplierInspectionEquipment2>()
                        .eq(BizSupplierInspectionEquipment2::getSupplierEnterpriseId, id)
                        .eq(BizSupplierInspectionEquipment2::getIsDele, "0"));
                vo.setInspectionEquipmentFlag(count9 > 0 ? "1" : "0");
            }

            //其他特别说明
            if ("0".equals(vo.getOtherSpecialNotesFlag())){
                int count10 = otherSpecialNotes2Manager.count(new LambdaQueryWrapper<BizSupplierOtherSpecialNotes2>()
                        .eq(BizSupplierOtherSpecialNotes2::getSupplierEnterpriseId, id)
                        .eq(BizSupplierOtherSpecialNotes2::getIsDele, "0"));
                vo.setOtherSpecialNotesFlag(count10 > 0 ? "1" : "0");
            }
        }
        return vo;
    }

    /**
     * 生成任务单号
     * @return
     */
    private String generate10CharUUID() {
        // 获取当前时间的最后5位字符
        String timePart = Long.toString(System.nanoTime(), 36);
        timePart = timePart.substring(timePart.length() - 5);

        // 生成随机5位字符
        String randomPart = UUID.randomUUID().toString()
                .replace("-", "")
                .substring(0, 5);

        return timePart + randomPart;
    }

    /**
     * 基本情况 企业规模
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateBasicInformation(EnterpriseAccess2Dto dto){
        //如果准入申请信息为空，则新增准入信息
        if (BeanUtils.isEmpty(dto.getId())){
            saveEnterpriseAccess(dto);
        }
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        BizSupplierAccessBasicInformation2 information = dto.getInformation();
        information.setSupplierEnterpriseId(supplierEnterpriseId);
        if (BeanUtils.isEmpty(information.getId())){
            information2Manager.save(information);
        }
        else {
            information2Manager.updateById(information);
        }
        dto.setInformation(information);
        return true;
    }

    /**
     * 企业资质
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateQualification(EnterpriseAccess2Dto dto){
        //如果准入申请信息为空，则新增准入信息
        if (BeanUtils.isEmpty(dto.getId())){
            saveEnterpriseAccess(dto);
        }
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        //验证必填资质
        validateQualification(dto);
        //删除旧数据
        qualificationDatabase2Manager.remove(new LambdaQueryWrapper<BizSupplierEnterpriseQualificationDatabase2>()
                .eq(BizSupplierEnterpriseQualificationDatabase2::getSupplierEnterpriseId,supplierEnterpriseId)
                .eq(BizSupplierEnterpriseQualificationDatabase2::getIsDele,"0"));

        //保存新数据
        Map<String, List<BizSupplierEnterpriseQualificationDatabase2>> qualificationMap = dto.getQualificationMap();
        Set<String> keySet = qualificationMap.keySet();
        List<BizSupplierEnterpriseQualificationDatabase2> qualificationList = new ArrayList<>();
        for (String key : keySet) {
            qualificationList.addAll(qualificationMap.get(key));
        }
        qualificationList.forEach(q -> {
            q.setSupplierEnterpriseId(supplierEnterpriseId);
            q.setEnterpriseId(dto.getSupplierId());
            q.setEnterpriseCode(dto.getSupplierCode());
            q.setId(null);
        });
        qualificationDatabase2Manager.saveBatch(qualificationList);
        return true;
    }

    private void validateQualification(EnterpriseAccess2Dto dto){
        Map<String, List<BizSupplierEnterpriseQualificationDatabase2>> qualificationMap = dto.getQualificationMap();

        //表单提交的资质类型
        List<BizSupplierEnterpriseQualificationDatabase2> qualification = qualificationMap.get("accessQualifications");
        Set<String> catNameSet = qualification.stream().map(q -> q.getQualificationCategoryName()).collect(Collectors.toSet());
        List<String> catNameList = catNameSet.stream().collect(Collectors.toList());

        //供应商配置的资质类型
        List<BizSupplierQualificationDatabase> qualificationDatabaseList = qualificationDatabaseManager.listByCategoryCode(null,dto.getSupplierId());
        List<String> supCatNameList = qualificationDatabaseList.stream().map(q -> q.getQualificationCategoryName()).collect(Collectors.toList());
        //供应商未配置的资质类型
//        List<String> subtractCatNameList = CollectionUtil.subtractToList(supCatNameList, catNameList);
        for (String s : supCatNameList) {
            catNameList.remove(s);
        }
        if (BeanUtils.isNotEmpty(catNameList) && catNameList.size() > 0){
            String subtractCatName = String.join(",", catNameList);
            throw new ApplicationException("请配置" + "【" + subtractCatName + "】类型的资质！");
        }
    }

    /**
     * 主营产品情况
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateMainProductsSalesStatus(EnterpriseAccess2Dto dto){
        //如果准入申请信息为空，则新增准入信息
        if (BeanUtils.isEmpty(dto.getId())){
            saveEnterpriseAccess(dto);
        }
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();

        mainProductsSalesStatus2Manager.remove(new LambdaQueryWrapper<BizSupplierMainProductsSalesStatus2>()
                .eq(BizSupplierMainProductsSalesStatus2::getSupplierEnterpriseId,supplierEnterpriseId)
                .eq(BizSupplierMainProductsSalesStatus2::getIsDele,"0"));


        //主营产品情况
        List<BizSupplierMainProductsSalesStatus2> salesStatus2List = dto.getSalesStatus2List();
        salesStatus2List.forEach(s -> {
            s.setSupplierEnterpriseId(supplierEnterpriseId);
            s.setId(null);
        });
        mainProductsSalesStatus2Manager.saveBatch(salesStatus2List);

        return true;
    }

    /**
     * 主要原材料及供应商
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateMainRawMaterialsSuppliers(EnterpriseAccess2Dto dto){
        //如果准入申请信息为空，则新增准入信息
        if (BeanUtils.isEmpty(dto.getId())){
            saveEnterpriseAccess(dto);
        }
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        //删除旧数据
        mainRawMaterialsSuppliers2Manager.remove(new LambdaQueryWrapper<BizSupplierMainRawMaterialsSuppliers2>()
                .eq(BizSupplierMainRawMaterialsSuppliers2::getSupplierEnterpriseId,supplierEnterpriseId)
                .eq(BizSupplierMainRawMaterialsSuppliers2::getIsDele,"0"));

        //保存新数据
        List<BizSupplierMainRawMaterialsSuppliers2> rawMaterialsSuppliersList = dto.getRawMaterialsSuppliersList();
        rawMaterialsSuppliersList.forEach(q -> {
            q.setSupplierEnterpriseId(supplierEnterpriseId);
            q.setId(null);
        });
        mainRawMaterialsSuppliers2Manager.saveBatch(rawMaterialsSuppliersList);
        return true;
    }

    /**
     * 生产制造过程绩效
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateProductionProcessPerformance(EnterpriseAccess2Dto dto){
        //如果准入申请信息为空，则新增准入信息
        if (BeanUtils.isEmpty(dto.getId())){
            saveEnterpriseAccess(dto);
        }
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        BizSupplierProductionProcessPerformance2Dto processPerformance = dto.getProcessPerformance();
        processPerformance.setSupplierEnterpriseId(supplierEnterpriseId);
        List<DefaultFile> files = processPerformance.getFiles();
        //保存
        if (BeanUtils.isEmpty(processPerformance.getId())){
            productionProcessPerformance2Manager.save(processPerformance);
        }
        //修改
        else {
            productionProcessPerformance2Manager.updateById(processPerformance);
            //删除旧的生产工艺流程
            productionProcessFlow2Manager.remove(new LambdaQueryWrapper<BizSupplierProductionProcessFlow2>()
                    .eq(BizSupplierProductionProcessFlow2::getSupplierProductionProcessPerformanceId,processPerformance.getId())
                    .eq(BizSupplierProductionProcessFlow2::getIsDele,"0"));
        }
        //保存新的生产工艺流程
        List<BizSupplierProductionProcessFlow2> processFlow2List = processPerformance.getProcessFlow2List();
        processFlow2List.forEach(p -> {
            p.setSupplierProductionProcessPerformanceId(processPerformance.getId());
            p.setId(null);
        });
        productionProcessFlow2Manager.saveBatch(processFlow2List);

//        更新附件
        if (files != null && files.size() > 0){
            List<String> fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
            fileManager.updateFileBizIdByIds(fileIds,processPerformance.getId());
        }
        dto.setProcessPerformance(processPerformance);
        return true;
    }

    /**
     * 主要生产设备
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateProductionEquipment(EnterpriseAccess2Dto dto){
        //如果准入申请信息为空，则新增准入信息
        if (BeanUtils.isEmpty(dto.getId())){
            saveEnterpriseAccess(dto);
        }
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        //删除旧数据
        productionEquipment2Manager.remove(new LambdaQueryWrapper<BizSupplierProductionEquipment2>()
                .eq(BizSupplierProductionEquipment2::getSupplierEnterpriseId,supplierEnterpriseId)
                .eq(BizSupplierProductionEquipment2::getIsDele,"0"));
        //保存新数据
        List<BizSupplierProductionEquipment2> productionEquipment2List = dto.getProductionEquipment2List();
        productionEquipment2List.forEach(e -> {
            e.setSupplierEnterpriseId(supplierEnterpriseId);
            e.setId(null);
        });
        List<DefaultFile> files = dto.getProductionEquipmentFiles();
        if (files != null && files.size() > 0){
            List<String> fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
            for (String fileId : fileIds) {
                fileManager.updateFilesByIds(fileId,dto.getId(),"productionEquipment");
            }
        }
        productionEquipment2Manager.saveBatch(productionEquipment2List);
        return true;
    }

    /**
     * 主要检验设备
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateInspectionEquipment(EnterpriseAccess2Dto dto){
        //如果准入申请信息为空，则新增准入信息
        if (BeanUtils.isEmpty(dto.getId())){
            saveEnterpriseAccess(dto);
        }
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        //删除旧数据
        inspectionEquipment2Manager.remove(new LambdaQueryWrapper<BizSupplierInspectionEquipment2>()
                .eq(BizSupplierInspectionEquipment2::getSupplierEnterpriseId,supplierEnterpriseId)
                .eq(BizSupplierInspectionEquipment2::getIsDele,"0"));
        //保存新数据
        List<BizSupplierInspectionEquipment2> inspectionEquipment2List = dto.getInspectionEquipment2List();
        inspectionEquipment2List.forEach(e -> {
            e.setSupplierEnterpriseId(supplierEnterpriseId);
            e.setId(null);
        });
        List<DefaultFile> files = dto.getInspectionEquipmentFiles();
        if (files != null && files.size() > 0){
            List<String> fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
            for (String fileId : fileIds) {
                fileManager.updateFilesByIds(fileId,dto.getId(),"inspectionEquipment");
            }
        }
        inspectionEquipment2Manager.saveBatch(inspectionEquipment2List);
        return true;
    }

    /**
     * 其他特别说明
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateOtherSpecialNotes(EnterpriseAccess2Dto dto){
        Boolean result = false;
        //如果准入申请信息为空，则新增准入信息
        if (BeanUtils.isEmpty(dto.getId())){
            saveEnterpriseAccess(dto);
        }
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        BizSupplierOtherSpecialNotes2 otherSpecialNotes = dto.getOtherSpecialNotes();
        otherSpecialNotes.setSupplierEnterpriseId(supplierEnterpriseId);
        List<DefaultFile> files = otherSpecialNotes.getFiles();
        if (BeanUtils.isEmpty(otherSpecialNotes.getId())){
            result = otherSpecialNotes2Manager.save(otherSpecialNotes);
        }
        else {
            result = otherSpecialNotes2Manager.updateById(otherSpecialNotes);
        }
//        更新附件
        if (files != null && files.size() > 0){
            List<String> fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
            fileManager.updateFileBizIdByIds(fileIds,otherSpecialNotes.getId());
        }
        dto.setOtherSpecialNotes(otherSpecialNotes);
        return result;
    }

    /**
     * 现场评审
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateReviewRatingDetails(EnterpriseAccess2Dto dto){
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        Map<String, List<BizSupplierReviewRatingDetails2Dto>> reviewRatingDetails2Map = dto.getReviewRatingDetails2Map();
        Set<String> keySet = reviewRatingDetails2Map.keySet();
        List<BizSupplierReviewRatingDetails2Dto> reviewRatingDetails2List = new ArrayList<>();
        for (String key : keySet) {
            reviewRatingDetails2List.addAll(reviewRatingDetails2Map.get(key));
        }
        //需评审成员
        Set<String> rpSet = new HashSet<>();
        reviewRatingDetails2List.forEach(q -> {
            q.setSupplierEnterpriseId(supplierEnterpriseId);
            if (BeanUtils.isNotEmpty(q.getId())){
                reviewRatingDetails2Manager.updateById(q);
            }else {
                reviewRatingDetails2Manager.save(q);
            }
            List<BizSupplierReviewRatingPanel2> panelList = q.getPanelList();
            panelList.forEach(p -> {
                p.setReviewRatingDetailsId(q.getId());
                if (BeanUtils.isNotEmpty(p.getId())){
                    reviewRatingPanel2Manager.updateById(p);
                }else {
                    rpSet.add(p.getRatingId());
                    reviewRatingPanel2Manager.save(p);
                }
            });
        });
        //基本情况审核
        if ("2".equals(dto.getStatus())){
            //添加需评审成员
            String reviewPanel = String.join(",", rpSet);
            dto.setReviewPanel(reviewPanel);
            this.update(new LambdaUpdateWrapper<BizSupplierEnterpriseAccess>()
                    .eq(BizSupplierEnterpriseAccess::getId,supplierEnterpriseId)
                    .set(BizSupplierEnterpriseAccess::getReviewPanel,reviewPanel));
        }
        //现场评审
        if ("4".equals(dto.getStatus())){
            //计算每个评分项的平均分
            for (BizSupplierReviewRatingDetails2Dto reviewRatingDetails : reviewRatingDetails2List) {
                String ratingDetailsId = reviewRatingDetails.getId();
                String score = reviewRatingPanel2Manager.calculateScore(ratingDetailsId);
                BigDecimal operationScore = new BigDecimal(score);
                reviewRatingDetails2Manager.update(new LambdaUpdateWrapper<BizSupplierReviewRatingDetails2>()
                        .eq(BizSupplierReviewRatingDetails2::getId,ratingDetailsId)
                        .set(BizSupplierReviewRatingDetails2::getOperationScore,operationScore));
            }
        }
        return true;
    }

    /**
     * 评定报告
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateReviewReport(EnterpriseAccess2Dto dto){
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        BizSupplierReviewReport2Dto reviewReport = dto.getReviewReport();
        reviewReport.setSupplierEnterpriseId(supplierEnterpriseId);
        //保存
        if (BeanUtils.isEmpty(reviewReport.getId())){
            reviewReport2Manager.save(reviewReport);
        }
        //修改
        else {
            reviewReport2Manager.updateById(reviewReport);
            //删除旧的评审成员
            reviewReportPanel2Manager.remove(new LambdaQueryWrapper<BizSupplierReviewReportPanel2>()
                    .eq(BizSupplierReviewReportPanel2::getReviewReportId,reviewReport.getId())
                    .eq(BizSupplierReviewReportPanel2::getIsDele,"0"));
        }
        //保存新的评审成员
        List<BizSupplierReviewReportPanel2> reportPanelList = reviewReport.getPanel2List();
        reportPanelList.forEach(p -> {
            p.setReviewReportId(reviewReport.getId());
            p.setId(null);
        });
        reviewReportPanel2Manager.saveBatch(reportPanelList);
        dto.setReviewReport(reviewReport);
        return true;
    }

    /**
     * 试生产评审
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateReviewTrialReport(EnterpriseAccess2Dto dto){
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        BizSupplierReviewTrialReport2Dto reviewTrialReport = dto.getReviewTrialReport();
        reviewTrialReport.setSupplierEnterpriseId(supplierEnterpriseId);
        //保存
        if (BeanUtils.isEmpty(reviewTrialReport.getId())){
            reviewTrialReport2Manager.save(reviewTrialReport);
        }
        //修改
        else {
            reviewTrialReport2Manager.updateById(reviewTrialReport);
            //删除旧的评审成员
            reviewTrialReportPanel2Manager.remove(new LambdaQueryWrapper<BizSupplierReviewTrialReportPanel2>()
                    .eq(BizSupplierReviewTrialReportPanel2::getReviewReportId,reviewTrialReport.getId())
                    .eq(BizSupplierReviewTrialReportPanel2::getIsDele,"0"));
        }
        //保存新的评审成员
        List<BizSupplierReviewTrialReportPanel2> panel2List = reviewTrialReport.getPanel2List();
        panel2List.forEach(p -> {
            p.setReviewReportId(reviewTrialReport.getId());
            p.setId(null);
        });
        reviewTrialReportPanel2Manager.saveBatch(panel2List);
        dto.setReviewTrialReport(reviewTrialReport);
        return true;
    }

    /**
     * 主营产品情况及质量业绩
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateMainProductsPerformance(EnterpriseAccess2Dto dto){
        //如果准入申请信息为空，则新增准入信息
        if (BeanUtils.isEmpty(dto.getId())){
            saveEnterpriseAccess(dto);
        }
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        MainProductsPerformance2Dto mainProductsPerformance = dto.getMainProductsPerformance();
        List<DefaultFile> files = mainProductsPerformance.getFiles();

        String supplierMainProductsPerformanceId = mainProductsPerformance.getId();
        mainProductsPerformance.setSupplierEnterpriseId(supplierEnterpriseId);
        //保存
        if (BeanUtils.isEmpty(supplierMainProductsPerformanceId)){
            //主营产品主表
            mainProductsPerformance2Manager.save(mainProductsPerformance);
        }
        //修改
        else {
            //主营产品主表
            mainProductsPerformance2Manager.updateById(mainProductsPerformance);
            //删除旧的子表数据
            mainProductsQualityPerformance2Manager.remove(new LambdaQueryWrapper<BizSupplierMainProductsQualityPerformance2>()
                    .eq(BizSupplierMainProductsQualityPerformance2::getSupplierMainProductsPerformanceId,supplierMainProductsPerformanceId)
                    .eq(BizSupplierMainProductsQualityPerformance2::getIsDele,"0"));
            mainProductsPerformanceCustomerComplaints2Manager.remove(new LambdaQueryWrapper<BizSupplierMainProductsPerformanceCustomerComplaints2>()
                    .eq(BizSupplierMainProductsPerformanceCustomerComplaints2::getSupplierMainProductsPerformanceId,supplierMainProductsPerformanceId)
                    .eq(BizSupplierMainProductsPerformanceCustomerComplaints2::getIsDele,"0"));
        }
        //主营产品质量表现
        List<BizSupplierMainProductsQualityPerformance2> qualityPerformance2List = mainProductsPerformance.getQualityPerformance2List();
        qualityPerformance2List.forEach(q -> {
            q.setSupplierMainProductsPerformanceId(mainProductsPerformance.getId());
            q.setId(null);
        });
        mainProductsQualityPerformance2Manager.saveBatch(qualityPerformance2List);
        //客户抱怨（上年度）
        List<BizSupplierMainProductsPerformanceCustomerComplaints2> customerComplaints2List = mainProductsPerformance.getCustomerComplaints2List();
        customerComplaints2List.forEach(c -> {
            c.setSupplierMainProductsPerformanceId(mainProductsPerformance.getId());
            c.setId(null);
        });
        mainProductsPerformanceCustomerComplaints2Manager.saveBatch(customerComplaints2List);

        //更新附件
        if (files != null && files.size() > 0){
            List<String> fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
            fileManager.updateFileBizIdByIds(fileIds,mainProductsPerformance.getId());
        }
        dto.setMainProductsPerformance(mainProductsPerformance);
        return true;
    }

    /**
     * 保存准入申请信息
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveEnterpriseAccess(EnterpriseAccess2Dto dto){
        boolean result = false;
        String number = sysIdentityManager.nextId("gyszrsqbm");
        String userId = ContextUtil.getCurrentUserId();
        String account = ContextUtil.getCurrentUserAccount();
        String userName = ContextUtil.getCurrentUserName();
        String currentOrgId = ContextUtil.getCurrentOrgId();
        String currentOrgName = ContextUtil.getCurrentOrgName();
        String currentOrgCode = ContextUtil.getCurrentOrgCode();
        LocalDateTime now = LocalDateTime.now();
        dto.setApplicantAccountId(userId);
        dto.setApplicantAccount(account);
        dto.setApplicantName(userName);
        dto.setApplyDate(now);
        dto.setSupplierAccessNumber(number);
        dto.setApplicantOrgCode(currentOrgCode);
        dto.setApplicantOrgName(currentOrgName);
        dto.setStatus("0");
        //1企业直接添加，2供应商准入申请，3企业准入申请
//        dto.setCreateMethod("3");
        if ("3".equals(dto.getCreateMethod())){
            dto.setEnterpriseId(currentOrgId);
            dto.setEnterpriseCode(currentOrgCode);
            dto.setEnterpriseName(currentOrgName);
        }
        result = save(dto);
        if (!result){
            return false;
        }
        List<BizSupplierMainSupplyMaterialCategory2> materialCategory2List = dto.getMaterialCategory2List();
        if (BeanUtils.isNotEmpty(materialCategory2List)){
            materialCategory2List.forEach(m -> m.setSupplierEnterpriseId(dto.getId()));
            result = materialCategory2Manager.saveBatch(materialCategory2List);
        }
        return result;
    }

    /**
     * 修改准入申请信息
     * @param dto
     * @return
     */
    public Boolean updateEnterpriseAccess(EnterpriseAccess2Dto dto){
        //删除旧数据
        materialCategory2Manager.remove(new LambdaQueryWrapper<BizSupplierMainSupplyMaterialCategory2>()
                .eq(BizSupplierMainSupplyMaterialCategory2::getSupplierEnterpriseId, dto.getId())
                .eq(BizSupplierMainSupplyMaterialCategory2::getIsDele, "0"));

        //保存新数据
        List<BizSupplierMainSupplyMaterialCategory2> materialCategory2List = dto.getMaterialCategory2List();
        materialCategory2List.forEach(m -> {
            m.setSupplierEnterpriseId(dto.getId());
            m.setId(null);
        });
        materialCategory2Manager.saveBatch(materialCategory2List);
        return updateById(dto);
    }
}
