package com.artfess.gyl.supplierApply.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商准入评定报告
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-20
 */
@Data
@ApiModel(value="BizSupplierReviewReport对象", description="供应商准入评定报告")
public class BizSupplierReviewReport extends BizDelModel<BizSupplierReviewReport> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "合格供应商ID")
    @TableField("SUPPLIER_ENTERPRISE_ID_")
    private String supplierEnterpriseId;

    @ApiModelProperty(value = "评审得分")
    @TableField("OPERATION_SCORE_")
    private BigDecimal operationScore;

    @ApiModelProperty(value = "评审证据（使用字典[多选]，1供应商基本情况调查表，2现场评审记录）")
    @TableField("REVIEW_EVIDENCE_")
    private String reviewEvidence;

    @ApiModelProperty(value = "评价描述")
    @TableField("REVIEW_DESC_")
    private String reviewDesc;

    @ApiModelProperty(value = "评审结论（使用字典，1合格，2试用，3淘汰）")
    @TableField("REVIEW_CONCLUSION_")
    private String reviewConclusion;

    @ApiModelProperty(value = "试用要求")
    @TableField("TRIAL_REQUIREMENTS_")
    private String trialRequirements;

    @ApiModelProperty(value = "确认人ID")
    @TableField("REVIEW_CONFIRMATION_ID_")
    private String reviewConfirmationId;

    @ApiModelProperty(value = "确认人ACCOUNT")
    @TableField("REVIEW_CONFIRMATION_ACCOUNT_")
    private String reviewConfirmationAccount;

    @ApiModelProperty(value = "确认人")
    @TableField("REVIEW_CONFIRMATION_NAME_")
    private String reviewConfirmationName;

    @ApiModelProperty(value = "确认时间")
    @TableField("REVIEW_CONFIRMATION_TIME_")
    private LocalDateTime reviewConfirmationTime;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;
}
