package com.artfess.gyl.supplierApply.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 主营产品情况及质量业绩表-客户抱怨（上年度）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-20
 */
@Data
@ApiModel(value="BizSupplierMainProductsPerformanceCustomerComplaints对象", description="主营产品情况及质量业绩表-客户抱怨（上年度）")
public class BizSupplierMainProductsPerformanceCustomerComplaints extends BizDelModel<BizSupplierMainProductsPerformanceCustomerComplaints> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主营产品情况及质量业绩ID")
    @TableField("SUPPLIER_MAIN_PRODUCTS_PERFORMANCE_ID_")
    private String supplierMainProductsPerformanceId;

    @ApiModelProperty(value = "客户抱怨问题")
    @TableField("CUSTOMER_COMPLAINTS_")
    private String customerComplaints;

    @ApiModelProperty(value = "提出时间")
    @TableField("PROPOSED_TIME_")
    private LocalDate proposedTime;

    @ApiModelProperty(value = "控制措施")
    @TableField("CONTROL_MEASURES_")
    private String controlMeasures;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Long seq;
}
