package com.artfess.gyl.supplierApply.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商准入审批记录表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-20
 */
@Data
@ApiModel(value="BizSupplierEnterpriseAccessApprovalRecord对象", description="供应商准入审批记录表")
public class BizSupplierEnterpriseAccessApprovalRecord extends BizDelModel<BizSupplierEnterpriseAccessApprovalRecord> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "合格供应商ID")
    @TableField("SUPPLIER_ENTERPRISE_ID_")
    private String supplierEnterpriseId;

    @ApiModelProperty(value = "任务单号（每次审批系统生成，多人审批时为同一任务单号）")
    @TableField("JOB_NUM_")
    private String jobNum;

    @ApiModelProperty(value = "准入状态（与供应商准入表状态保持一致）")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "是否首节点（0否，1是）")
    @TableField("FIRST_NODE_")
    private String firstNode;

    @ApiModelProperty(value = "是否尾节点（0否，1是）")
    @TableField("TAIL_NODE_")
    private String tailNode;

    @ApiModelProperty(value = "审批人ID")
    @TableField("APPROVAL_ID_")
    private String approvalId;

    @ApiModelProperty(value = "审批人ACCOUNT")
    @TableField("APPROVAL_ACCOUNT_")
    private String approvalAccount;

    @ApiModelProperty(value = "审批人")
    @TableField("APPROVAL_NAME_")
    private String approvalName;

    @ApiModelProperty(value = "审批人单位ID")
    @TableField("APPROVAL_ORG_ID_")
    private String approvalOrgId;

    @ApiModelProperty(value = "审批人单位CODE")
    @TableField("APPROVAL_ORG_CODE_")
    private String approvalOrgCode;

    @ApiModelProperty(value = "审批人单位")
    @TableField("APPROVAL_ORG_NAME_")
    private String approvalOrgName;

    @ApiModelProperty(value = "审批时间")
    @TableField("APPROVAL_DATE_")
    private LocalDateTime approvalDate;

    @ApiModelProperty(value = "审批结果（0驳回，1通过）")
    @TableField("APPROVAL_RESULT_")
    private String approvalResult;

    @ApiModelProperty(value = "审批意见")
    @TableField("APPROVAL_OPINION_")
    private String approvalOpinion;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;
}
