package com.artfess.gyl.supplierApply.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BizDelModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 合格供应商表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-20
 */
@Data
@ApiModel(value="BizSupplierEnterprise对象", description="合格供应商表")
public class BizSupplierEnterprise extends BizDelModel<BizSupplierEnterprise> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "准入申请ID（关联准入申请表ID）")
    @TableField("SUPPLIER_ENTERPRISE_ACCESS_ID_")
    private String supplierEnterpriseAccessId;

    @ApiModelProperty(value = "准入申请流水号")
    @TableField("SUPPLIER_ACCESS_NUMBER_")
    private String supplierAccessNumber;

    @ApiModelProperty(value = "供应商编号（按照企业生成供应商流水编号）")
    @TableField("SUPPLIER_NUMBER_")
    private String supplierNumber;

    @ApiModelProperty(value = "订单总金额")
    @TableField("TOTAL_AMOUNT_")
    private String totalAmount;

    @ApiModelProperty(value = "企业ID")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业名称（企业平台名称）")
    @Excel(name = "企业名称",column = "A")
    @TableField("ENTERPRISE_NAME_")
    private String enterpriseName;

    @ApiModelProperty(value = "企业编码（企业平台编码）")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "供应商ID")
    @TableField("SUPPLIER_ID_")
    private String supplierId;

    @ApiModelProperty(value = "供应商名称")
    @Excel(name = "供应商名称",column = "B")
    @TableField("SUPPLIER_NAME_")
    private String supplierName;

    @ApiModelProperty(value = "供应商编码（企业平台编码）")
    @TableField("SUPPLIER_CODE_")
    private String supplierCode;

    @TableField("CAT_ID_")
    @ApiModelProperty( value="分类ID")
    private String catId;

    @TableField("CAT_NO_")
    @ApiModelProperty( value="分类编号")
    private String catNo;

    @TableField("CAT_NAME_")
    @ApiModelProperty( value="分类名称")
    private String catName;

    @TableField("GRADING_ID_")
    @ApiModelProperty( value="分级ID")
    private String gradingId;

    @TableField("GRADING_CODE_")
    @ApiModelProperty( value="分级编号")
    private String gradingNo;

    @TableField("GRADING_NAME_")
    @ApiModelProperty( value="分级名称")
    private String gradingName;

    @ApiModelProperty(value = "申请时间")
    @TableField("APPLY_DATE")
    private LocalDateTime applyDate;

    @ApiModelProperty(value = "入选时间")
    @TableField("SELECTION_DATE")
    private LocalDateTime selectionDate;

    @ApiModelProperty(value = "推荐部门")
    @TableField("RECOMMENDED_DEPARTMENT_")
    private String recommendedDepartment;

    @ApiModelProperty(value = "推荐人")
    @TableField("REFERRER_")
    private String referrer;

    @ApiModelProperty(value = "上次考核时间")
    @TableField("LAST_ASSESSMENT_DATE_")
    private LocalDate lastAssessmentDate;

    @ApiModelProperty(value = "上次考核类型（与考核评价中类型一致）")
    @TableField("LAST_ASSESSMENT_TYPE")
    private String lastAssessmentType;

    @ApiModelProperty(value = "上次考核得分/级别")
    @TableField("LAST_ASSESSMENT_SCORE_")
    private String lastAssessmentScore;

    @ApiModelProperty(value = "上次交易时间")
    @TableField("LAST_TRANSACTION_TIME_")
    private LocalDate lastTransactionTime;

    @ApiModelProperty(value = "交易状态（1：正常，2：冻结）")
    @TableField("TRANSACTION_STATUS_")
    private String transactionStatus;

    @ApiModelProperty(value = "类型（1合格供应商，2退出供应商，3淘汰供应商）")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "创建方式（1企业直接添加，2供应商准入申请，3企业准入申请）")
    @TableField("CREATE_METHOD_")
    private String createMethod;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "综合评分（预留字段）")
    @TableField("OVERALL_RATING_")
    private Integer overallRating;

    @ApiModelProperty(value = "综合评价（预留字段）")
    @TableField("COMPREHENSIVE_EVALUATION_")
    private String comprehensiveEvaluation;

    @ApiModelProperty(value = "生产设备附件集")
    @TableField(exist = false)
    private List<DefaultFile> productionEquipmentFiles;

    @ApiModelProperty(value = "检验设备附件集")
    @TableField(exist = false)
    private List<DefaultFile> inspectionEquipmentFiles;
}
