package com.artfess.gyl.supplierApply.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商基本信息表（通过原biz_enterprise进行扩展）		说明：供应商基本信息变更后通过
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-20
 */
@Data
@ApiModel(value="BizSupplierAccessBasicInformation对象", description="供应商基本信息表（通过原biz_enterprise进行扩展）		说明：供应商基本信息变更后通过")
public class BizSupplierAccessBasicInformation extends BizDelModel<BizSupplierAccessBasicInformation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "合格供应商ID")
    @TableField("SUPPLIER_ENTERPRISE_ID_")
    private String supplierEnterpriseId;

    @ApiModelProperty(value = "企业信息ID（关联企业信息表ID）")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "质量联系人")
    @TableField("QUALITY_CONTACT_PERSON_")
    private String qualityContactPerson;

    @ApiModelProperty(value = "质量联系人电话")
    @TableField("QUALITY_CONTACT_PERSON_PHONE_")
    private String qualityContactPersonPhone;

    @ApiModelProperty(value = "开户银行")
    @TableField("OPENING_BANK_")
    private String openingBank;

    @ApiModelProperty(value = "银行账号")
    @TableField("BANK_")
    private String bank;

    @ApiModelProperty(value = "公司网址")
    @TableField("COMPANY_WEBSITE_")
    private String companyWebsite;

    @ApiModelProperty(value = "生产地址")
    @TableField("PRODUCTION_ADDRESS_")
    private String productionAddress;

    @ApiModelProperty(value = "固定资产 (万元 )")
    @TableField("FIXED_ASSETS_")
    private String fixedAssets;

    @ApiModelProperty(value = "上年销售额 ( 万元)")
    @TableField("LAST_YEAR_SALES_")
    private String lastYearSales;

    @ApiModelProperty(value = "主营产品上年度销量")
    @TableField("MAIN_PRODUCTS_LAST_YEAR_SALES_")
    private String mainProductsLastYearSales;

    @ApiModelProperty(value = "主营产上年度销售额(万元 )")
    @TableField("MAIN_PRODUCTS_LAST_YEAR_SALES_REVENUE_")
    private String mainProductsLastYearSalesRevenue;

    @ApiModelProperty(value = "技术工程师 (人)")
    @TableField("TECHNICAL_ENGINEER_")
    private String technicalEngineer;

    @ApiModelProperty(value = "质量管理人员  (人)")
    @TableField("QUALITY_MANAGEMENT_PERSONNEL_")
    private String qualityManagementPersonnel;

    @ApiModelProperty(value = "员工人数 (人)")
    @TableField("EMPLOYEES_NUMBER_")
    private String employeesNumber;

    @ApiModelProperty(value = "生产作业人员 (人)")
    @TableField("PRODUCTION_OPERATORS_")
    private String productionOperators;
}
