package com.artfess.gyl.supplierAccess.dto;

import com.artfess.base.util.BeanUtils;
import com.artfess.gyl.supplierAccess.model.BizSupplierAccessBasic;
import com.artfess.gyl.supplierAccess.model.BizSupplierAccessConfiguration;
import com.artfess.gyl.supplierAccess.model.BizSupplierAccessProcess;
import com.artfess.gyl.supplierAccess.model.BizSupplierAccessQualification;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

@Data
@ApiModel(value="BizSupplierAccessConfigurationDto对象", description="供应商准入配置Dto")
public class BizSupplierAccessConfigurationDto {

    @ApiModelProperty(value = "主键_ID")
    private String id;

    @ApiModelProperty(value = "配置编码")
    private String code;

    @ApiModelProperty(value = "配置名称")
    private String name;

    @ApiModelProperty(value = "配置描述")
    private String desc;

    @ApiModelProperty(value = "企业ID")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编号")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    private String isDele;

    @ApiModelProperty(value = "是否启用，1启用，0禁用")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "关联物料分类名称（用逗号分隔）")
    @TableField("GATEGORY_NAMES_")
    private String gategoryNames;

    @ApiModelProperty(value = "关联物料分类ID集合")
    private List<String> gategoryIds;

    @ApiModelProperty(value = "基本情况调查配置")
    private BizSupplierAccessBasic basic;

    @ApiModelProperty(value = "业务流程配置")
    private BizSupplierAccessProcess process;

    @ApiModelProperty(value = "准入资质配置集合（required：必填资质，unnecessary：选填资质）")
    private Map<String,List<BizSupplierAccessQualification>> qualificationMap;

    public static BizSupplierAccessConfiguration parse(BizSupplierAccessConfigurationDto dto){
        BizSupplierAccessConfiguration model = new BizSupplierAccessConfiguration();
        try {
            BeanUtils.copyNotNullProperties(model,dto);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return model;
    }
}
