package com.artfess.gyl.supplierAccess.dao;

import com.artfess.gyl.base.model.BizSupplierQualificationDatabase;
import com.artfess.gyl.supplierAccess.model.BizSupplierAccessConfiguration;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 供应商准入配置表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-07
 */
public interface BizSupplierAccessConfigurationDao extends BaseMapper<BizSupplierAccessConfiguration> {

    /**
     * 分页查询
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizSupplierAccessConfiguration> queryPage(IPage<BizSupplierAccessConfiguration> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BizSupplierAccessConfiguration> convert2Wrapper);

    /**
     * 修改启用状态
     * @param id
     * @param status
     * @return
     */
    int updateStatus(@Param("id") String id,@Param("status") String status);
}
