package com.artfess.gyl.job;

import com.artfess.gyl.base.manager.BizSupplierQualificationDatabaseManager;
import com.artfess.gyl.base.model.BizSupplierQualificationDatabase;
import com.artfess.job.model.BaseJob;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import lombok.extern.slf4j.Slf4j;
import org.quartz.JobExecutionContext;

import javax.annotation.Resource;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Slf4j
public class SupplierQualificationTimeLimitJob extends BaseJob {
    @Resource
    private BizSupplierQualificationDatabaseManager databaseManager;

    @Override
    public void executeJob(JobExecutionContext context){
        LocalDateTime start = LocalDateTime.now();
        log.info("任务开始时间:{}",start);
        LambdaUpdateWrapper<BizSupplierQualificationDatabase> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(BizSupplierQualificationDatabase::getStatus,2)
                .eq(BizSupplierQualificationDatabase::getTimeLimit,0)
                .lt(BizSupplierQualificationDatabase::getValidUntil,start.toLocalDate());
        LocalDateTime end = LocalDateTime.now();
        long minutes = Duration.between(start, end).toMinutes();
        log.info("任务结束耗时：{} 分钟", minutes);
    }
}
