package com.artfess.gyl.ecologyOa.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.gyl.ecologyOa.manager.EcologyOaManager;
import com.artfess.base.exception.BaseException;
import com.artfess.base.util.BeanUtils;
import com.artfess.gyl.ecologyOa.vo.CreateWorkVo;
import com.artfess.gyl.utils.RSAUtils;
import com.artfess.redis.util.RedisUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.google.gson.Gson;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2025/8/5 16:14
 */
@Service
public class EcologyOaManagerImpl implements EcologyOaManager {

    @Value("${ecologyOa.host}")
    private String host;
    @Value("${ecologyOa.spk}")
    private String spk;
    @Value("${ecologyOa.appid}")
    private String appid;
    @Value("${ecologyOa.secret}")
    private String secret;
    @Value("${ecologyOa.getTokenUrl}")
    private String getTokenUrl;
    @Value("${ecologyOa.getUserIdUrl}")
    private String getUserIdUrl;
    @Value("${ecologyOa.getTaskCountUrl}")
    private String getTaskCountUrl;
    @Value("${ecologyOa.getToDoWorkListUrl}")
    private String getToDoWorkListUrl;
    @Value("${ecologyOa.getHandledWorkListUrl}")
    private String getHandledWorkListUrl;
    @Value("${ecologyOa.getRequestWorkListUrl}")
    private String getRequestWorkListUrl;
    @Value("${ecologyOa.createWorkUrl}")
    private String createWorkUrl;
    @Value("${ecologyOa.deleteWorkUrl}")
    private String deleteWorkUrl;
    @Value("${ecologyOa.getSsoTokenUrl}")
    private String getSsoTokenUrl;
    @Value("${ecologyOa.ssoAppid}")
    private String ssoAppid;

    @Autowired
    RedisUtil redisUtil;

    @Override
    public String getToken() {
        String result = null;
        //1.查询redis是否存在
        Object oaToken = redisUtil.get("oaToken");
        if(BeanUtil.isNotEmpty(oaToken)){
            return oaToken.toString();
        }

        try (CloseableHttpClient httpClient = HttpClients.createDefault()) {
            HttpPost httpPost = new HttpPost(host+getTokenUrl);
            httpPost.setHeader("appid", appid);
            httpPost.setHeader("secret", secret);
            try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
                JSONObject jsonObject = JSONUtil.parseObj(EntityUtils.toString(response.getEntity()));
                String code = jsonObject.getStr("code");
                if(!code.equals("0")){
                    throw new BaseException("获取流程系统token失败："+jsonObject.getStr("msg"));
                }
                result = jsonObject.getStr("token");

                //将token保存到redis并设置过期时长29分钟（oa系统token过期为30分钟）
                redisUtil.set("oaToken",result,60*29);

            }
        } catch (IOException e) {
            System.out.println();
            throw new BaseException("获取流程系统token失败："+e.getMessage());
        }
        return result;

    }

    @Override
    public String getOaUserId(String mobile) {
        String result = null;

        try {
            URIBuilder uriBuilder = new URIBuilder(host+getUserIdUrl);
            uriBuilder.addParameter("mobile", mobile);
            URI uri = uriBuilder.build();

            HttpGet httpGet = new HttpGet(uri);
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute(httpGet)) {
                    JSONObject jsonObject = JSONUtil.parseObj(EntityUtils.toString(response.getEntity()));
                    result = jsonObject.getStr("hrmBillid");
            }
        } catch (Exception e) {
            System.out.println();
            throw new BaseException("获取流程系统token失败："+e.getMessage());
        }
        return result;

    }

    @Override
    public Integer getTaskCount() {
        Integer result = 0;
        //1.获取token
        String token = getToken();

        //2.获取当前用户id
        String mobile = ContextUtil.getCurrentUser().getMobile();
        String oaUserId = getOaUserId(mobile);
        if(BeanUtils.isEmpty(oaUserId)){
            return result;
        }

        String encrypt = null;
        //3.根据spk对用户id进行rsa加密
        try {
            encrypt = RSAUtils.encrypt(spk, oaUserId);
        } catch (Exception e) {
            throw new BaseException("RSA加密失败："+e.getMessage());
        }

        //4.获取待办数量
        try (CloseableHttpClient httpClient = HttpClients.createDefault()) {
            HttpPost httpPost = new HttpPost(host+getTaskCountUrl);
            httpPost.setHeader("appid", appid);
            httpPost.setHeader("token", token);
            httpPost.setHeader("userid", encrypt);
            try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
                String s = EntityUtils.toString(response.getEntity());
                result = Integer.valueOf(s.toString());
            }
        } catch (IOException e) {
            System.out.println();
            throw new BaseException("获取流程系统token失败："+e.getMessage());
        }
        return result;

    }

    @Override
    public JSONArray getWorkList(String url) {
        return getToDoWorkList(url);
    }

    public JSONArray getToDoWorkList(String url) {
        JSONArray result = null;
        //1.获取token
        String token = getToken();

        //2.获取当前用户id
        String mobile = ContextUtil.getCurrentUser().getMobile();
        String oaUserId = getOaUserId(mobile);
        if(BeanUtils.isEmpty(oaUserId)){
            return result;
        }

        String encrypt = null;
        //3.根据spk对用户id进行rsa加密
        try {
            encrypt = RSAUtils.encrypt(spk, oaUserId);
        } catch (Exception e) {
            throw new BaseException("RSA加密失败："+e.getMessage());
        }

        //4.获取流程列表
        try (CloseableHttpClient httpClient = HttpClients.createDefault()) {
            HttpPost httpPost = new HttpPost(host+url);
            httpPost.setHeader("appid", appid);
            httpPost.setHeader("token", token);
            httpPost.setHeader("userid", encrypt);
            try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
               result = JSONUtil.parseArray(EntityUtils.toString(response.getEntity()));
            }
        } catch (IOException e) {
            System.out.println();
            throw new BaseException("获取流程系统token失败："+e.getMessage());
        }
        return result;
    }

    @Override
    public JSONObject createWork(CreateWorkVo createWorkVo, String createUserMobile) {
        JSONObject result = null;
        //1.获取token
        String token = getToken();
        if(BeanUtils.isEmpty(createUserMobile)){
            createUserMobile = ContextUtil.getCurrentUser().getMobile();
        }
        //2.获取当前用户id
        String oaUserId = getOaUserId(createUserMobile);
        if(BeanUtils.isEmpty(oaUserId)){
            throw new BaseException("请推送当前用户到流程审批系统");
        }

        String encrypt = null;
        //3.根据spk对用户id进行rsa加密
        try {
            encrypt = RSAUtils.encrypt(spk, oaUserId);
        } catch (Exception e) {
            throw new BaseException("RSA加密失败："+e.getMessage());
        }

        //4.获取流程列表
        try (CloseableHttpClient httpClient = HttpClients.createDefault()) {
            HttpPost httpPost = new HttpPost(host+createWorkUrl);
            httpPost.setHeader("appid", appid);
            httpPost.setHeader("token", token);
            httpPost.setHeader("userid", encrypt);
            String json = new Gson().toJson(createWorkVo);

            StringEntity entity = new StringEntity(json, StandardCharsets.UTF_8);
            httpPost.setEntity(entity);

            try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
                 result = JSONUtil.parseObj(EntityUtils.toString(response.getEntity()));
            }
        } catch (IOException e) {
            System.out.println();
            throw new BaseException("获取流程系统token失败："+e.getMessage());
        }
        return result;
    }

    @Override
    public String getSsoToken() {
        String result = null;

        try (CloseableHttpClient httpClient = HttpClients.createDefault()) {
            HttpPost httpPost = new HttpPost(host+getSsoTokenUrl);

            List<NameValuePair> params = new ArrayList<>();
            params.add(new BasicNameValuePair("appid", ssoAppid));
            params.add(new BasicNameValuePair("loginid", ContextUtil.getCurrentUserAccount()));
            httpPost.setEntity(new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));

            try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
                result = EntityUtils.toString(response.getEntity());
            }
        } catch (IOException e) {
            System.out.println();
            throw new BaseException("获取流程系统ssoToken失败："+e.getMessage());
        }

        return result;
    }

}
