package com.artfess.gyl.base.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 企业人员管理
 *
 * @author huqi
 * @since 2025-11-21
 */
@Data
@TableName("biz_enterprise_personnel")
@ApiModel(value="BizEnterprisePersonnel对象", description="企业人员管理")
public class BizEnterprisePersonnel extends BizDelModel<BizEnterprisePersonnel> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "企业id")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业名称")
    @TableField("ENTERPRISE_NAME_")
    private String enterpriseName;

    @ApiModelProperty(value = "企业编码")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "用户姓名")
    @TableField("FULLNAME_")
    private String fullname;

    @ApiModelProperty(value = "用户编号")
    @TableField("USER_NUMBER_")
    private String userNumber;

    @ApiModelProperty(value = "性别（男，女，未知）")
    @TableField("SEX_")
    private String sex;

    @ApiModelProperty(value = "出生日期")
    @TableField("BIRTHDAY_")
    private LocalDate birthday;

    @ApiModelProperty(value = "国家")
    @TableField("COUNTRY_")
    private String country;

    @ApiModelProperty(value = "民族")
    @TableField("NATION_")
    private String nation;

    @ApiModelProperty(value = "政治面貌（使用字典：01中共党员，02中共预备党员，03共青团员，04民革党员，05民盟盟员，06民建会员，07民进会员，08农工党党员，09致公党党员，10九三学社社员，11台盟盟员，12无党派人士，13群众）")
    @TableField("POLITICAL_OUTLOOK_")
    private String politicalOutlook;

    @ApiModelProperty(value = "身份证号")
    @TableField("ID_CARD_")
    private String idCard;

    @ApiModelProperty(value = "工作地址")
    @TableField("ADDRESS_")
    private String address;

    @ApiModelProperty(value = "参加工作时间")
    @TableField("ENTRY_DATE_")
    private LocalDate entryDate;

    @ApiModelProperty(value = "职务")
    @TableField("DUTIES_")
    private String duties;

    @ApiModelProperty(value = "执业资质")
    @TableField("PROFESSIONAL_QUALIFICATIONS_")
    private String professionalQualifications;

    @ApiModelProperty(value = "学历")
    @TableField("EDUCATION_")
    private String education;

    @ApiModelProperty(value = "学位")
    @TableField("ACADEMIC_DEGREE_")
    private String academicDegree;

    @ApiModelProperty(value = "健康状况")
    @TableField("HEALTH_CONDITION_")
    private String healthCondition;

    @ApiModelProperty(value = "办公电话")
    @TableField("PHONE_")
    private String phone;

    @ApiModelProperty(value = "手机号码")
    @TableField("MOBILE_")
    private String mobile;

    @ApiModelProperty(value = "QQ")
    @TableField("QQ_")
    private String qq;

    @ApiModelProperty(value = "MSN")
    @TableField("MSN_")
    private String msn;

    @ApiModelProperty(value = "邮箱")
    @TableField("EMAIL_")
    private String email;

    @ApiModelProperty(value = "所属行政区划_ID（关联行政区划表）")
    @TableField("SYS_AREAS_ID_")
    private String sysAreasId;

    @ApiModelProperty(value = "所属行政区划_NAME（关联行政区划表）")
    @TableField("SYS_AREAS_NAME_")
    private String sysAreasName;

    @ApiModelProperty(value = "所属行政区划_全路径ID（关联行政区划表）")
    @TableField("SYS_AREAS_ID_PATH_")
    private String sysAreasIdPath;

    @ApiModelProperty(value = "属行政区划_全路径名称（关联行政区划表）")
    @TableField("SYS_AREAS_NAME_PATH_")
    private String sysAreasNamePath;

    @ApiModelProperty(value = "门户账号")
    @TableField("ACCOUNT_")
    private String account;

    @ApiModelProperty(value = "简历")
    @TableField("BIOGRAPHICAL_NOTES_")
    private String biographicalNotes;

    @ApiModelProperty(value = "照片附件URL")
    @TableField("PHOTO_")
    private String photo;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "状态（0：禁用，1：启用）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "附件集")
    @TableField(exist = false)
    List<DefaultFile> files;

}
