package com.artfess.gyl.base.manager.impl;

import com.artfess.base.util.StringUtil;
import com.artfess.gyl.base.model.BizSupplierMaterialCategory;
import com.artfess.gyl.base.model.BizSupplierQualificationCategory;
import com.artfess.gyl.base.dao.BizSupplierQualificationCategoryDao;
import com.artfess.gyl.base.manager.BizSupplierQualificationCategoryManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * 供应商资质类型表 服务实现类
 *
 * @author 系统管理员
 * @since 2025-11-08
 */
@Service
public class BizSupplierQualificationCategoryManagerImpl extends BaseManagerImpl<BizSupplierQualificationCategoryDao, BizSupplierQualificationCategory> implements BizSupplierQualificationCategoryManager {

    @Resource
    private SysIdentityManager sysIdentityManager;

    @Override
    public boolean updateStatusById(String id, String status) {
        LambdaUpdateWrapper<BizSupplierQualificationCategory> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(BizSupplierQualificationCategory::getId, id);
        wrapper.set(BizSupplierQualificationCategory::getStatus, status);
        return this.update(wrapper);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean save(BizSupplierQualificationCategory entity){
        String no = sysIdentityManager.nextId("wzflbm");
        entity.setQualificationCategoryCode(no);
        if(StringUtil.isEmpty(entity.getStatus())){
            entity.setStatus("1");
        }
        return super.save(entity);
    }
}
