package com.artfess.gyl.base.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.util.StringUtil;
import com.artfess.gyl.base.manager.BizSupplierCategorySupplyScopeManager;
import com.artfess.gyl.base.model.*;
import com.artfess.gyl.base.dao.BizSupplierCategoryConfigurationDao;
import com.artfess.gyl.base.manager.BizSupplierCategoryConfigurationManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import org.apache.http.util.Asserts;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

/**
 * 供应商分类管理表 服务实现类
 *
 * @author 系统管理员
 * @since 2025-11-07
 */
@Service
public class BizSupplierCategoryConfigurationManagerImpl extends BaseManagerImpl<BizSupplierCategoryConfigurationDao, BizSupplierCategoryConfiguration> implements BizSupplierCategoryConfigurationManager {

    @Resource
    private SysIdentityManager sysIdentityManager;

    @Resource
    private BizSupplierCategorySupplyScopeManager scopeManager;

    @Override
    public boolean updateStatusById(String id, String status) {
        LambdaUpdateWrapper<BizSupplierCategoryConfiguration> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(BizSupplierCategoryConfiguration::getId, id);
        wrapper.set(BizSupplierCategoryConfiguration::getStatus, status);
        return this.update(wrapper);
    }

    @Override
    @Transactional(readOnly = true)
    public BizSupplierCategoryConfiguration getByCategoryId(String categoryId) {
        return baseMapper.getByCategoryId(categoryId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean save(BizSupplierCategoryConfiguration entity) {
        String no = sysIdentityManager.nextId("gysflbm");
        entity.setCode(no);
        if (StringUtil.isEmpty(entity.getStatus())) {
            entity.setStatus("1");
        }
        if (!super.save(entity)) {
            return false;
        }
        List<BizSupplierCategorySupplyScope> scopes = entity.getScopes();
        String id = entity.getId();
        if (scopes != null && !scopes.isEmpty()) {
            scopes.forEach(s -> {
                s.setId(null);
                s.setSupplierCategoryConfigurationId(id);
            });
            if (!scopeManager.saveBatch(scopes)) {
                throw new ApplicationException("分类关联失败");
            }
            return true;
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateById(BizSupplierCategoryConfiguration entity) {
        boolean update = super.updateById(entity);
        if (!update){
            return false;
        }
        List<BizSupplierCategorySupplyScope> scopes = entity.getScopes();
        String id = entity.getId();
        //删除之前数据
        LambdaQueryWrapper<BizSupplierCategorySupplyScope> wrapper = new LambdaQueryWrapper<BizSupplierCategorySupplyScope>()
                .eq(BizSupplierCategorySupplyScope::getSupplierCategoryConfigurationId, id);
        scopeManager.remove(wrapper);
        if (scopes!=null && !scopes.isEmpty()) {
            scopes.forEach(s->{
                s.setId(null);
                s.setSupplierCategoryConfigurationId(id);
            });
            if (!scopeManager.saveBatch(scopes)){
                throw new ApplicationException("分类关联失败");
            }
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        //删除关联数据
        LambdaQueryWrapper<BizSupplierCategorySupplyScope> wrapper = new LambdaQueryWrapper<BizSupplierCategorySupplyScope>()
                .in(BizSupplierCategorySupplyScope::getSupplierMaterialCategoryId, idList);
        scopeManager.remove(wrapper);
        //删除主表数据
        return super.removeByIds(idList);
    }

    @Override
    @Transactional(readOnly = true)
    public BizSupplierCategoryConfiguration getById(Serializable id) {
        BizSupplierCategoryConfiguration entity = super.getById(id);
        //查询关联明细
        LambdaQueryWrapper<BizSupplierCategorySupplyScope> wrapper = new LambdaQueryWrapper<BizSupplierCategorySupplyScope>()
                .eq(BizSupplierCategorySupplyScope::getSupplierCategoryConfigurationId, entity.getId());
        List<BizSupplierCategorySupplyScope> scopes = scopeManager.list(wrapper);
        if (!CollectionUtils.isEmpty(scopes)){
            entity.setScopes(scopes);
        }
        return entity;
    }

}
