package com.artfess.gyl.base.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.gyl.base.model.BizContract;
import com.artfess.gyl.base.dao.BizContractDao;
import com.artfess.gyl.base.manager.BizContractManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import lombok.extern.log4j.Log4j2;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.ContractService;
import net.qiyuesuo.sdk.bean.contract.ViewUrlRequest;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.impl.ContractServiceImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 采购合同表 服务实现类
 *
 * @author huqi
 * @since 2025-12-04
 */
@Log4j2
@Service
public class BizContractManagerImpl extends BaseManagerImpl<BizContractDao, BizContract> implements BizContractManager {


    @Value("${contractSys.serverUrl}")
    private String serverUrl;
    @Value("${contractSys.accessKey}")
    private String accessKey;
    @Value("${contractSys.accessSecret}")
    private String accessSecret;

    private ContractService contractService;

    public void init() {
        SDKClient sdkClient = new SDKClient(serverUrl, accessKey, accessSecret);
        contractService = new ContractServiceImpl(sdkClient);
    }

    @Override
    public String viewContract(String threeContrId) {
        if(BeanUtils.isEmpty(threeContrId)){
             throw new ApplicationException("请输入正确的合同id");
        }
        //初始化
        init();
        //方法调用
        ViewUrlRequest request = new ViewUrlRequest();
        request.setContractId(Long.valueOf(threeContrId));
        request.setPageType(ViewUrlRequest.PageType.CONTENT);
        String viewUrl = null;
        try {
            viewUrl = contractService.viewUrl(request);
        } catch (PrivateAppException e) {
            System.out.println(LocalDateTime.now()+"预览合同失败："+e.getMessage());
            throw new BaseException("预览合同失败："+e.getMessage());
        }
        log.info("=====预览地址:"+viewUrl);
        return viewUrl;
    }

    @Override
    public void downContract(HttpServletResponse response, List<Long> threeContrIds) {
        if(BeanUtils.isEmpty(threeContrIds) || threeContrIds.size()<=0){
            throw new ApplicationException("请输入正确的合同id");
        }
        init();
        try(
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                OutputStream os = response.getOutputStream();
        ) {
            String fileName = URLEncoder.encode("合同文件.zip", "UTF-8");
            response.setContentType("APPLICATION/OCTET-STREAM");
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.addHeader("filename", fileName);
            contractService.batchDownload(threeContrIds, baos);
            response.setHeader("Content-Length", String.valueOf(baos.size()));
            os.write(baos.toByteArray());
            os.flush();
        } catch (Exception e) {
            throw new BaseException("下载合同失败："+e.getMessage());
        }
    }
}
