package com.artfess.gyl.base.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.gyl.base.model.BizEnterpriseBusinessLicense;
import com.artfess.base.manager.BaseManager;
import com.artfess.gyl.supplierApply3.model.BizSupplierEnterpriseRegisterInformation;

/**
 * 企业营业执照 服务类
 *
 * @author huqi
 * @since 2025-11-21
 */
public interface BizEnterpriseBusinessLicenseManager extends BaseManager<BizEnterpriseBusinessLicense> {

    /**
     * 通用查询
     * @param queryFilter
     * @return
     */
    PageList<BizEnterpriseBusinessLicense> queryBySupplierVersion(QueryFilter<BizEnterpriseBusinessLicense> queryFilter);

    /**
     * 根据组织id查询营业执照信息
     * @param orgId
     * @return
     */
    BizEnterpriseBusinessLicense getModelByOrgId(String orgId);
}
