package com.artfess.gyl.base.manager;

import com.artfess.gyl.base.model.BizContractCallback;
import com.artfess.base.manager.BaseManager;

/**
 * 电子合同回调记录表 服务类
 *
 * @author 管理员
 * @since 2025-12-10
 */
public interface BizContractCallbackManager extends BaseManager<BizContractCallback> {

    /**
     * 第三方合同签署完成后回调接口（保存记录并更新用户注册状态）
     * dataSourceType 数据类型（1.合同，2.附件，3.框架协议）
     */
    void signingCompleted(String contractId, String sn, String status,
                          String type, String contact,
                          String operatorName, String operatorMobile,
                          String operatorNumber,String receiverNumber,
                          String accessKey, String secretKey,
                          String dataSourceType);
}
