package com.artfess.gyl.base.dao;

import com.artfess.gyl.base.model.BizAccessory;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 通用附件表 Mapper 接口
 *
 * @author 管理员
 * @since 2025-12-10
 */
public interface BizAccessoryDao extends BaseMapper<BizAccessory> {
    /**
     * 按照资源ID分页查询附件数据
     * @param page 分页参数
     * @param queryWrapper 查询条件
     * @return 附件分页数据
     */
    IPage<BizAccessory> selectPageBySourceId(@Param("page") IPage<BizAccessory> page,
                                             @Param(Constants.WRAPPER) Wrapper<BizAccessory> queryWrapper);

    /**
     * 根据ID获取附件信息
     * @param id 附件ID
     * @return 附件信息
     */
    BizAccessory selectById(@Param("id") String id);

    /**
     * 根据创建人ID获取附件信息
     * @param creatorId 创建人ID
     * @return 附件信息
     */
    BizAccessory selectByCreatorId(@Param("creatorId") String creatorId);

}
