package com.artfess.gyl.base.controller;


import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.base.model.BizContractCallback;
import com.artfess.gyl.base.manager.BizContractCallbackManager;

/**
 * 电子合同回调记录表 前端控制器
 *
 * @author 管理员
 * @since 2025-12-10
 */
@RestController
@RequestMapping("/contractCallback/v1/")
public class BizContractCallbackController extends BaseController<BizContractCallbackManager, BizContractCallback> {

    @ApiImplicitParams({
            @ApiImplicitParam(name = "contractId", value = "文件编号", dataType = "String"),
            @ApiImplicitParam(name = "sn", value = "文件自定义编号", dataType = "String"),
            @ApiImplicitParam(name = "status", value = "文件状态", dataType = "String"),
            @ApiImplicitParam(name = "type", value = "回调类型 1.签署战略供应商", dataType = "String"),
            @ApiImplicitParam(name = "contact", value = "联系方式", dataType = "String"),
            @ApiImplicitParam(name = "operatorName", value = "操作人姓名", dataType = "String"),
            @ApiImplicitParam(name = "operatorMobile", value = "操作人手机号", dataType = "String"),
            @ApiImplicitParam(name = "operatorNumber", value = "操作人员工编号", dataType = "String"),
            @ApiImplicitParam(name = "receiverNumber", value = "经办人员工编号", dataType = "String"),
            @ApiImplicitParam(name = "accessKey", value = "ak", dataType = "String"),
            @ApiImplicitParam(name = "secretKey", value = "sk", dataType = "String"),
    })
    @PostMapping("/signingCompleted")
    @ApiOperation(value = "M-签署完成（合同系统回调接口）")
    public void signingCompleted(String contractId,
                                 String sn, String status,String type, String contact,
                                 String operatorName, String operatorMobile,
                                 String operatorNumber,String receiverNumber,
                                 String accessKey, String secretKey) {
        baseService.signingCompleted(contractId,sn,status,type, contact,operatorName,operatorMobile,operatorNumber,receiverNumber, accessKey,secretKey,"2");
    }

}
