package com.artfess.gyl.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.util.MinioUtil;
import com.artfess.gyl.base.manager.BizAccessoryManager;
import com.artfess.gyl.base.manager.BizContractCallbackManager;
import com.artfess.gyl.base.model.BizAccessory;
import com.artfess.gyl.base.vo.Chunk;
import com.google.common.net.HttpHeaders;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.base.model.BizAccessory;
import com.artfess.gyl.base.manager.BizAccessoryManager;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

/**
 * 通用附件表 前端控制器
 *
 * @author 管理员
 * @since 2025-12-10
 */
@RestController
@RequestMapping("/BizAccessory/v1/")
@Api(tags = "合同附件管理接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
@Slf4j
public class BizAccessoryController extends BaseController<BizAccessoryManager, BizAccessory> {

    @PostMapping("/getBySourceId/{sourceId}")
    @ApiOperation(value = "S-通过资源Id不分页查询附件信息", httpMethod = "Post")
    public CommonResult<List<BizAccessory>> getBySourceId(@ApiParam(name = "sourceId", value = "资源Id") @PathVariable String sourceId) {
        List<BizAccessory> result = baseService.getAccessoryBySourceId(sourceId);
        return new CommonResult<List<BizAccessory>>(true, "操作成功", result);
    }

    @PostMapping("/save")
    @ApiOperation(value = "S-批量保存附件信息", httpMethod = "Post")
    public CommonResult<String> saveBizAccessory(@ApiParam(name = "BizAccessory", value = "附件对象") @RequestBody List<BizAccessory> list) {
        boolean status = baseService.saveAccessory(list);
        String msg = status ? "保存成功" : "保存失败";
        return new CommonResult<String>(status, msg);

    }


    @PostMapping("/minIoAllDownFile")
    @ApiOperation(value = "S-通用下载接口", httpMethod = "POST", notes = "通用下载接口")
    public void downTest(@ApiParam(name = "ids", value = "ids", required = true)
                         @RequestParam(value = "ids", required = true) String ids,
                         @ApiParam(name = "bizPath", value = "bizPath", required = true)
                         @RequestParam(value = "bizPath", required = true) String bizPath, HttpServletResponse response) throws Exception {
        baseService.minIoDownFile(ids, bizPath, response);
    }

    @PostMapping("/downFile/source")
    @ApiOperation(value = "S-通用下载接口", httpMethod = "POST", notes = "根据资源id通用下载接口")
    public void downFileBySourceIds(@ApiParam(name = "ids", value = "ids", required = true)
                                    @RequestParam(value = "ids", required = true) String ids,
                                    @ApiParam(name = "bizPath", value = "bizPath", required = true)
                                    @RequestParam(value = "bizPath", required = true) String bizPath, HttpServletResponse response) throws Exception {
        baseService.minIoDownFileBySourceId(ids, bizPath, response);
    }

    @GetMapping("/minIoDown")
    @ApiOperation(value = "S-通用下载接口", httpMethod = "POST", notes = "通用下载接口")
    public void minIoDown(@ApiParam(name = "name", value = "name", required = true)
                          @RequestParam(value = "name", required = true) String name,
                          @ApiParam(name = "bizPath", value = "bizPath", required = true)
                          @RequestParam(value = "bizPath", required = true) String bizPath, HttpServletResponse response) throws Exception {
        baseService.minIoDown(name, bizPath, response);
    }

    @GetMapping("/minIoDownPub")
    @ApiOperation(value = "M-公开文件通用下载接口", httpMethod = "POST", notes = "通用下载接口")
    public void minIoDownPub(@ApiParam(name = "name", value = "name", required = true)
                             @RequestParam(value = "name", required = true) String name,
                             @ApiParam(name = "bizPath", value = "bizPath", required = true)
                             @RequestParam(value = "bizPath", required = true) String bizPath,
                             HttpServletResponse response) throws Exception {
        baseService.minIoDown(name, bizPath,"cgptpub", response);
    }

    @PostMapping("/ShardUpload")
    @ApiOperation(value = "S-大文件分片上传接口", httpMethod = "POST", notes = "大文件分片上传接口（上传完毕需调用合并接口）")
    public CommonResult<String> shardUpload(@RequestBody MultipartFile upFile, @ApiParam(name = "chunk",value = "分片文件对象",required = true) Chunk chunk, HttpServletResponse response) throws Exception {
        log.info("通用附件管理-附件上传接口请求参数：{}",chunk,response);
        chunk.setFile(upFile);
        String result = baseService.fileUploadPost(chunk, response);
        boolean status = result.equals("over") || result.equals("ok");
        log.info("通用附件管理-附件上传接口响应结果：{}",result);
        return new CommonResult<String>(status, status?"上传成功":"上传失败",result);
    }

    @PostMapping("/mergeFileToMinIO")
    @ApiOperation(value = "S-大文件分片上传合并接口", httpMethod = "POST", notes = "大文件分片上传合并文件异步上传MinIO")
    public CommonResult<BizAccessory> mergeFileToMinIO(
            @ApiParam(name = "bizPath",value = "MinIO中的业务文件夹",required = true) @RequestParam String bizPath,
            @ApiParam(name = "fileName",value = "文件名",required = true) @RequestParam String fileName,
            @ApiParam(name = "fileName",value = "文件名",required = false) @RequestParam String bucketName) throws Exception {
        log.info("通用附件管理-合并文件异步上传MinIO接口请求参数：{}",bizPath,fileName);
        BizAccessory BizAccessory = baseService.minioUpload(bizPath, fileName,bucketName);
        log.info("通用附件管理-合并文件异步上传MinIO接口响应结果：{}",BizAccessory);
        return new CommonResult<BizAccessory>(true, "上传成功", BizAccessory);
    }

    @RequestMapping("/minioUpload")
    @ApiOperation(value = "普通附件上传接口", httpMethod = "POST", notes = "普通附件上传接口")
    public CommonResult<BizAccessory> minioUpload(MultipartFile file,String bizPath ,HttpServletResponse response) throws Exception {
        BizAccessory BizAccessory = this.baseService.minioUpload(file,bizPath , response);
        return new CommonResult<BizAccessory>(true, "上传成功",BizAccessory);
    }

    @RequestMapping("/minioUploadBuc")
    @ApiOperation(value = "普通附件上传接口（传入桶名）", httpMethod = "POST", notes = "普通附件上传接口")
    public CommonResult<BizAccessory> minioUploadBuc(MultipartFile file,String bizPath,String bucketName ,HttpServletResponse response) throws Exception {
        BizAccessory BizAccessory = this.baseService.minioUpload(file,bizPath,bucketName , response);
        return new CommonResult<BizAccessory>(true, "上传成功",BizAccessory);
    }

    @RequestMapping("/minioBatchUpload")
    @ApiOperation(value = "普通附件批量上传接口", httpMethod = "POST", notes = "普通附件上传接口")
    public CommonResult<List<BizAccessory>> minioBatchUpload(List<MultipartFile> fileList,String bizPath ,HttpServletResponse response) throws Exception {
        List<BizAccessory> BizAccessoryList = this.baseService.minioBatchUpload(fileList,bizPath, response);
        return new CommonResult<List<BizAccessory>>(true, "上传成功",BizAccessoryList);
    }


    @PostMapping("/delete")
    @ApiOperation(value = "S-批量删除附件信息", httpMethod = "POST")
    public CommonResult<String> delete(@ApiParam(name = "ids", value = "ID集合") @RequestParam("ids") String ids) throws Exception {
        Assert.notNull(ids, "主键集合不能为空");
        boolean state = baseService.removeByIds(Arrays.asList(ids.split(",")));
        String msg = state ? "删除成功" : "删除失败";
        return new CommonResult<String>(state, msg);
    }


    @PostMapping("/removeBySourceId/{sourceId}")
    @ApiOperation(value = "S-通过资源ID删除附件信息", httpMethod = "POST")
    public CommonResult<String> removeBySourceId(@ApiParam(name = "sourceId", value = "资源ID") @PathVariable String sourceId) throws Exception {
        boolean status = baseService.removeBySourceId(sourceId);
        String msg = status ? "删除成功" : "删除失败";
        return new CommonResult<String>(true, msg);
    }


    @PostMapping("/getPageBySourceId")
    @ApiOperation(value = "S-通过资源ID分页查询附件信息",notes = "必须传入SOURCE_ID_", httpMethod = "POST")
    public CommonResult<PageList<BizAccessory>> getPageBySourceId(@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<BizAccessory> queryFilter){
        PageList<BizAccessory> result = baseService.getAccessoryPageBySourceId(queryFilter);
        return new CommonResult<>(true,"操作成功",result);
    }


}
