package com.artfess.gyl.thirdParty.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 
 *
 * @author 系统管理员
 * @since 2025-11-10
 */
@Data
@TableName("biz_category")
@ApiModel(value="BizCategory对象", description="物资分类")
public class BizCategory extends BizDelModel<BizCategory> {

    @TableId("id_")
    @ApiModelProperty( value="ID")
    private String id;

    @TableField("cat_no")
    @ApiModelProperty( value="分类编号")
    private String catNo;

    @TableField("cat_name")
    @ApiModelProperty( value="名称")
    private String catName;

    @TableField("cat_pid")
    @ApiModelProperty( value="父级分类ID")
    private String catPid;

    @TableField("cat_fno")
    @ApiModelProperty( value="父级分类编号")
    private String catFno;

    @TableField("status")
    @ApiModelProperty( value="状态")
    private Boolean status;

    @TableField("sort")
    @ApiModelProperty( value="排序")
    private Integer sort;

    @TableField("system_code")
    @ApiModelProperty( value="系统标识")
    private String systemCode;

    @TableField("scm_sort_id")
    private String scmSortId;

    @TableField("scm_sort_path")
    private String scmSortPath;

    @ApiModelProperty(value = "物资分类名称")
    @TableField(exist = false)
    private String categoryName;

    @ApiModelProperty(value = "物资分类id")
    @TableField(exist = false)
    private String categoryId;

    @TableField(exist = false)
    @ApiModelProperty(value = "子类")
    private List<BizCategory> children;
}
