package com.artfess.gyl.supplierOut.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 淘汰供应商记录表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-12-04
 */
@Data
@ApiModel(value="BizSupplierEnterpriseOut对象", description="淘汰供应商记录表")
public class BizSupplierEnterpriseOut extends BizDelModel<BizSupplierEnterpriseOut> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "合格供应商ID")
    @TableField("SUPPLIER_ENTERPRISE_ID_")
    private String supplierEnterpriseId;

    @ApiModelProperty(value = "准入申请流水号")
    @TableField("SUPPLIER_ACCESS_NUMBER_")
    private String supplierAccessNumber;

    @ApiModelProperty(value = "供应商ID")
    @TableField("SUPPLIER_ID_")
    private String supplierId;

    @ApiModelProperty(value = "供应商编码（企业平台编码）")
    @TableField("SUPPLIER_CODE_")
    private String supplierCode;

    @ApiModelProperty(value = "供应商名称")
    @TableField("SUPPLIER_NAME_")
    private String supplierName;

    @ApiModelProperty(value = "供应商地址")
    @TableField("SUPPLIER_ADDR_")
    private String supplierAddr;

    @ApiModelProperty(value = "供应商联系人")
    @TableField("SUPPLIER_CONTACT_")
    private String supplierContact;

    @ApiModelProperty(value = "供应商联系电话")
    @TableField("SUPPLIER_TEL_")
    private String supplierTel;

    @ApiModelProperty(value = "供应商类型")
    @TableField("SUPPLIER_OWNER_TYPE_")
    private String supplierOwnerType;

    @ApiModelProperty(value = "供应商法定代表人")
    @TableField("SUPPLIER_COMPANY_EBE_")
    private String supplierCompanyEbe;

    @ApiModelProperty(value = "分类ID")
    @TableField("CAT_ID_")
    private String catId;

    @ApiModelProperty(value = "分类编号")
    @TableField("CAT_NO_")
    private String catNo;

    @ApiModelProperty(value = "分类名称")
    @TableField("CAT_NAME_")
    private String catName;

    @ApiModelProperty(value = "分级ID")
    @TableField("GRADING_DI_")
    private String gradingId;

    @ApiModelProperty(value = "分级编号")
    @TableField("GRADING_CODE_")
    private String gradingCode;

    @ApiModelProperty(value = "分级名称")
    @TableField("GRADING_NAME_")
    private String gradingName;

    @ApiModelProperty(value = "企业ID")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "企业名称")
    @TableField("ENTERPRISE_NAME_")
    private String enterpriseName;

    @ApiModelProperty(value = "合作时间")
    @TableField("COOPERATION_DATE_")
    private LocalDateTime cooperationDate;

    @ApiModelProperty(value = "淘汰时间")
    @TableField("OUT_DATE_")
    private LocalDateTime outDate;

    @ApiModelProperty(value = "淘汰类型（1技术薄弱，2质量管控不达标，3绩效不达标，4私自变更，5其他）")
    @TableField("OUT_TYPE_")
    private String outType;

    @ApiModelProperty(value = "类型（2退出供应商，3淘汰供应商）")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "详细原因")
    @TableField("RESULT_")
    private String result;

    @ApiModelProperty(value = "供货情况")
    @TableField(exist = false)
    private List<BizSupplierEnterpriseOutSupplyCondition> supplyConditionList;
}
