package com.artfess.gyl.supplierOut.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.valid.AddGroup;
import com.artfess.gyl.supplierApply.dto.EnterpriseDto;
import com.artfess.gyl.supplierApply.model.BizSupplierEnterprise;
import com.artfess.gyl.supplierApply.vo.EnterprisePageVo;
import com.artfess.gyl.supplierApply2.model.BizSupplierEnterpriseAccess;
import com.artfess.gyl.supplierApply2.vo.EnterpriseAccess2PageVo;
import com.artfess.gyl.supplierOut.vo.SupplierEnterpriseOutPageVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.supplierOut.model.BizSupplierEnterpriseOut;
import com.artfess.gyl.supplierOut.manager.BizSupplierEnterpriseOutManager;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

/**
 * 淘汰供应商记录表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-12-04
 */
@RestController
@RequestMapping("/bizSupplierEnterpriseOut/v1/")
@Api(tags = "淘汰供应商记录表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizSupplierEnterpriseOutController extends BaseController<BizSupplierEnterpriseOutManager, BizSupplierEnterpriseOut> {

    @PostMapping("/saveModel")
    @ApiOperation("保存-淘汰供应商")
    public CommonResult<String> saveModel(@ApiParam(name = "model", value = "实体信息") @Validated({AddGroup.class}) @RequestBody BizSupplierEnterpriseOut model) {
        Boolean result = baseService.saveModel(model);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(model,"保存成功");
    }

    @GetMapping("/getInfo")
    @ApiOperation("查询详情")
    public BizSupplierEnterpriseOut getInfo(@RequestParam String id) {
        return baseService.getInfo(id);
    }

    @GetMapping("/getBySupplierEnterpriseId")
    @ApiOperation("根据合格供应商ID抓取淘汰供应商信息")
    public BizSupplierEnterpriseOut getBySupplierEnterpriseId(@RequestParam String supplierEnterpriseId) {
        return baseService.getBySupplierEnterpriseId(supplierEnterpriseId);
    }

    @PostMapping(value = "/queryPage", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询-淘汰供应商列表")
    public PageList<BizSupplierEnterpriseOut> queryPage(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizSupplierEnterpriseOut> queryFilter,
                                                @ApiParam(name = "role", value = "供应商还是企业查询（1企业，2供应商）") @RequestParam String role) throws InvocationTargetException, IllegalAccessException {
        IUser user = ContextUtil.getCurrentUser();
        if (!Objects.requireNonNull(user).isAdmin()){
            if ("1".equals(role)){
                queryFilter.addFilter("ENTERPRISE_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
            }
            if ("2".equals(role)){
                queryFilter.addFilter("SUPPLIER_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
            }
        }
        return baseService.queryPage(queryFilter);
    }
}
