package com.artfess.gyl.supplierEva.vo;

import com.artfess.gyl.supplierEva.model.*;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.beanutils.BeanUtils;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.List;

@Data
public class EvaluationVo extends BizSupplierPerformanceEvaluation {

    @ApiModelProperty(value = "供应商ID")
    private String supplierId;

    @ApiModelProperty(value = "供应商")
    private String supplierName;

    @ApiModelProperty(value = "供应商编号")
    private String supplierCode;

    @ApiModelProperty(value = "等级(1：优秀，2：良好，3：合格，4：可改善，5：不合格)")
    private String level;

    @ApiModelProperty(value = "评价结论（1合格，2可改善，3不合格）")
    private String assessmentResult;

    @ApiModelProperty(value = "处置类型 0.无处置 1.预警 2.限期")
    private String processType;

    @ApiModelProperty(value = "状态(1：已完成，2：已提交待评分，3评分中，4评分完毕待评价，5取消/关闭)")
    private String status;

    @ApiModelProperty(value = "是否已经评分")
    private String isOpt;

    @ApiModelProperty(value = "通知状态")
    private String notificationStatus;

    @ApiModelProperty(value = "通知单id")
    private String notificationId;

    @ApiModelProperty(value = "整改措施id")
    private String reportId;

    @ApiModelProperty(value = "整改状态")
    private String correctionStatus;

    @ApiModelProperty(value = "实际得分")
    private BigDecimal operationScore;

    @ApiModelProperty(value = "评分明细")
    private List<BizSupplierPerformanceEvaluationRating> details;

    @ApiModelProperty(value = "考核记录")
    private List<BizSupplierPerformanceEvaluationApprovalRecord> records;

    @ApiModelProperty(value = "考核通知")
    private BizSupplierPerformanceEvaluationNotification notification;

    @ApiModelProperty(value = "整改报告")
    private BizSupplierPerformanceEvaluationCorrectionReport report;

    public EvaluationVo(){

    }

    public EvaluationVo(BizSupplierPerformanceEvaluation evaluation) {
        try {
            BeanUtils.copyProperties(this,evaluation);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}
