package com.artfess.gyl.supplierEva.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商绩效考核评价评分明细表
 *
 * @author huqi
 * @since 2025-11-12
 */
@Data
@TableName("biz_supplier_performance_evaluation_rating")
@ApiModel(value="BizSupplierPerformanceEvaluationRating对象", description="供应商绩效考核评价评分明细表")
public class BizSupplierPerformanceEvaluationRating extends BizDelModel<BizSupplierPerformanceEvaluationRating> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "考核评价ID")
    @TableField("PERFORMANCE_EVALUATION_ID_")
    private String performanceEvaluationId;

    @ApiModelProperty(value = "考核评价ID")
    @TableField("PERFORMANCE_EVALUATION_RESULT_ID_")
    private String performanceEvaluationResultId;

    @ApiModelProperty(value = "评审配置ID")
    @TableField("PERFORMANCE_EVALUATION_CONFIGURATION_ID_")
    private String performanceEvaluationConfigurationId;

    @ApiModelProperty(value = "绩效考核分类ID")
    @TableField("ASSESSMENT_INDICATOR_TYPE_ID_")
    private String assessmentIndicatorTypeId;

    @ApiModelProperty(value = "绩效考核分类CODE")
    @TableField("ASSESSMENT_INDICATOR_TYPE_CODE_")
    private String assessmentIndicatorTypeCode;

    @ApiModelProperty(value = "绩效考核分类NAME")
    @TableField("ASSESSMENT_INDICATOR_TYPE_NAME_")
    private String assessmentIndicatorTypeName;

    @ApiModelProperty(value = "评审指标ID")
    @TableField("PERFORMANCE_EVALUATION_DETAILS_ID_")
    private String performanceEvaluationDetailsId;

    @ApiModelProperty(value = "评审指标编码")
    @TableField("PERFORMANCE_EVALUATION_DETAILS_CODE_")
    private String performanceEvaluationDetailsCode;

    @ApiModelProperty(value = "评审内容")
    @TableField("PERFORMANCE_EVALUATION_DETAILS_NAME_")
    private String performanceEvaluationDetailsName;

    @ApiModelProperty(value = "评审要求")
    @TableField("DESC_")
    private String desc;

    @ApiModelProperty(value = "分值")
    @TableField("SCORE_")
    private Integer score;

    @ApiModelProperty(value = "权重（百分比）")
    @TableField("WEIGHT_")
    private Float weight;

    @ApiModelProperty(value = "评分时间")
    @TableField("RATING_TIME_")
    private LocalDateTime ratingTime;

    @ApiModelProperty(value = "得分(多人对同一项指标进行评分取平均值)")
    @TableField("OPERATION_SCORE_")
    private BigDecimal operationScore;

    @ApiModelProperty(value = "状态(1：已完成，0：未完成)")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "是否完成审核(0. 未完成 1.已完成)")
    @TableField(exist = false)
    private String isOpt;

    @ApiModelProperty(value = "评审用户")
    @TableField(exist = false)
    List<BizSupplierPerformanceEvaluationRatingUser> users;
}
