package com.artfess.gyl.supplierEva.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商绩效考核通知信息表
 *
 * @author 管理员
 * @since 2025-12-12
 */
@Data
@TableName("biz_supplier_performance_evaluation_notification_template")
@ApiModel(value="BizSupplierPerformanceEvaluationNotificationTemplate对象", description="供应商绩效考核通知信息表")
public class BizSupplierPerformanceEvaluationNotificationTemplate extends BizDelModel<BizSupplierPerformanceEvaluationNotificationTemplate> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;


    @ApiModelProperty(value = "考核配置名称")
    @TableField("VALUATION_CONFIGURATION_NAME_")
    private String valuationConfigurationName;

    @ApiModelProperty(value = "考核类型（1月度考核，2季度考核，3年度考核，4自定义）")
    @TableField("ASSESSMENT_TYPE_")
    private String assessmentType;


    @ApiModelProperty(value = "考核年度")
    @TableField("ASSESSMENT_YEAR_")
    private Integer assessmentYear;

    @ApiModelProperty(value = "考核月度")
    @TableField("ASSESSMENT_MONTH_")
    private Integer assessmentMonth;

    @ApiModelProperty(value = "考核季度")
    @TableField("ASSESSMENT_QUATER_")
    private Integer assessmentQuater;

    @ApiModelProperty(value = "状态(1：已完成评分，2：已提交待评分，3评分中)")
    @TableField("STATUS_")
    private String status="0";

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "考核结果")
    @TableField("ASSESSMENT_RESULT_")
    private String assessmentResult;

    @ApiModelProperty(value = "处理类型（1质量预警，2限期整改，3淘汰）")
    @TableField("process_type_")
    private String processType;

    @ApiModelProperty(value = "通知标题")
    @TableField("notification_title_")
    private String notificationTitle;

    @ApiModelProperty(value = "通知内容")
    @TableField("notification_content_")
    private String notificationContent;

    @ApiModelProperty(value = "企业联系人")
    @TableField("enterprise_contact_")
    private String enterpriseContact;

    @ApiModelProperty(value = "企业联系电话")
    @TableField("enterprise_tel_")
    private String enterpriseTel;

    @ApiModelProperty(value = "企业联系地址")
    @TableField("enterprise_address_")
    private String enterpriseAddress;

    @ApiModelProperty(value = "等级(1：优秀，2：良好，3：合格，4：可改善，5：不合格)")
    @TableField("LEVEL_")
    private String level;

    @ApiModelProperty(value = "通知日期")
    @TableField("notify_date_")
    private LocalDateTime notifyDate;

    @ApiModelProperty(value = "要求回复截止日期")
    @TableField("reply_deadline_")
    private LocalDateTime replyDeadline;

    @ApiModelProperty(value = "要求完成截止日期")
    @TableField("finish_deadline_")
    private LocalDateTime finishDeadline;

    @ApiModelProperty(value = "组织拓展信息")
    @TableField("org_expand_")
    private String orgExpand;



}
