package com.artfess.gyl.supplierEva.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.math.BigDecimal;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商绩效考核通知信息表
 *
 * @author huqi
 * @since 2025-11-12
 */
@Data
@TableName("biz_supplier_performance_evaluation_notification")
@ApiModel(value="BizSupplierPerformanceEvaluationNotification对象", description="供应商绩效考核通知信息表")
public class BizSupplierPerformanceEvaluationNotification extends BizDelModel<BizSupplierPerformanceEvaluationNotification> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "考核评价ID")
    @TableField("PERFORMANCE_EVALUATION_ID_")
    private String performanceEvaluationId;

    @ApiModelProperty(value = "通知分发类型(1.通过绩效考核分发 2.手动分发 默认为1)")
    @TableField("DISTRIBUTE_TYPE_")
    private Integer distributeType;

    @ApiModelProperty(value = "处理类型（1质量预警，2限期整改）")
    @TableField("PROCESS_TYPE_")
    private String processType;

    @ApiModelProperty(value = "企业ID")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "企业名称")
    @TableField("ENTERPRISE_NAME_")
    private String enterpriseName;

    @ApiModelProperty(value = "合格供应商ID")
    @TableField("SUPPLIER_ID_")
    private String supplierId;

    @ApiModelProperty(value = "供应商名称")
    @TableField("SUPPLIER_NAME_")
    private String supplierName;

    @ApiModelProperty(value = "供应商编号")
    @TableField("SUPPLIER_CODE_")
    private String supplierCode;

    @ApiModelProperty(value = "实际考核得分")
    @TableField("OPERATION_SCORE_")
    private BigDecimal operationScore;

    @ApiModelProperty(value = "等级(1：优秀，2：良好，3：合格，4：可改善，5：不合格)")
    @TableField("LEVEL_")
    private String level;

    @ApiModelProperty(value = "发起人ID")
    @TableField("INITIATOR_ID_")
    private String initiatorId;

    @ApiModelProperty(value = "发起人ACCOUNT")
    @TableField("INITIATOR_ACCOUNT_")
    private String initiatorAccount;

    @ApiModelProperty(value = "发起人姓名")
    @TableField("INITIATOR_NAME_")
    private String initiatorName;

    @ApiModelProperty(value = "考核配置名称")
    @TableField("VALUATION_CONFIGURATION_NAME_")
    private String valuationConfigurationName;

    @ApiModelProperty(value = "考核配置编码")
    @TableField("VALUATION_CONFIGURATION_CODE_")
    private String valuationConfigurationCode;

    @ApiModelProperty(value = "考核类型（1月度考核，2季度考核，3年度考核，4自定义）")
    @TableField("ASSESSMENT_TYPE_")
    private String assessmentType;

    @ApiModelProperty(value = "考核年度")
    @TableField("ASSESSMENT_YEAR_")
    private Integer assessmentYear;

    @ApiModelProperty(value = "考核月度")
    @TableField("ASSESSMENT_MONTH_")
    private Integer assessmentMonth;

    @ApiModelProperty(value = "考核季度")
    @TableField("ASSESSMENT_QUATER_")
    private Integer assessmentQuater;

    @ApiModelProperty(value = "考核结果")
    @TableField("ASSESSMENT_RESULT_")
    private String assessmentResult;

    @ApiModelProperty(value = "通知标题")
    @TableField("NOTIFICATION_TITLE_")
    private String notificationTitle;

    @ApiModelProperty(value = "通知内容")
    @TableField("NOTIFICATION_CONTENT_")
    private String notificationContent;

    @ApiModelProperty(value = "企业联系人")
    @TableField("ENTERPRISE_CONTACT_")
    private String enterpriseContact;

    @ApiModelProperty(value = "企业联系电话")
    @TableField("ENTERPRISE_TEL_")
    private String enterpriseTel;

    @ApiModelProperty(value = "企业联系地址")
    @TableField("ENTERPRISE_ADDRESS_")
    private String enterpriseAddress;

    @ApiModelProperty(value = "通知日期")
    @TableField("NOTIFY_DATE_")
    private LocalDateTime notifyDate;

    @ApiModelProperty(value = "要求回复截止日期")
    @TableField("REPLY_DEADLINE_")
    private LocalDateTime replyDeadline;

    @ApiModelProperty(value = "要求完成截止日期")
    @TableField("FINISH_DEADLINE_")
    private LocalDateTime finishDeadline;

    @ApiModelProperty(value = "通知状态(1已发送，2已确认，3已超期，4已关闭)")
    @TableField("NOTIFICATION_STATUS_")
    private String notificationStatus;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "整改报告id")
    @TableField(exist = false)
    private String reportId;

    @ApiModelProperty(value = "整改状态")
    @TableField(exist = false)
    private Integer correctionStatus;

    @ApiModelProperty(value = "整改报告")
    @TableField(exist = false)
    private BizSupplierPerformanceEvaluationCorrectionReport report;
}
