package com.artfess.gyl.supplierEva.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商绩效考核评价表
 *
 * @author huqi
 * @since 2025-11-12
 */
@Data
@TableName("biz_supplier_performance_evaluation")
@ApiModel(value="BizSupplierPerformanceEvaluation对象", description="供应商绩效考核评价表")
public class BizSupplierPerformanceEvaluation extends BizDelModel<BizSupplierPerformanceEvaluation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "绩效考核配置ID")
    @TableField("VALUATION_CONFIGURATION_ID_")
    private String valuationConfigurationId;

    @ApiModelProperty(value = "绩效考核配置NAME")
    @TableField("VALUATION_CONFIGURATION_NAME_")
    private String valuationConfigurationName;

    @ApiModelProperty(value = "绩效考核配置CODE")
    @TableField("VALUATION_CONFIGURATION_CODE_")
    private String valuationConfigurationCode;

    @ApiModelProperty(value = "企业ID")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "企业名称")
    @TableField("ENTERPRISE_NAME_")
    private String enterpriseName;

    @ApiModelProperty(value = "供应商分类id")
    @TableField("SUPPLIER_CATEGORY_ID_")
    private String supplierCategoryId;

    @ApiModelProperty(value = "供应商分类编码")
    @TableField("SUPPLIER_CATEGORY_CODE_")
    private String supplierCategoryCode;

    @ApiModelProperty(value = "供应商分类名称")
    @TableField("SUPPLIER_CATEGORY_NAME_")
    private String supplierCategoryName;

    @ApiModelProperty(value = "发起人ID")
    @TableField("INITIATOR_ID_")
    private String initiatorId;

    @ApiModelProperty(value = "发起人ACCOUNT")
    @TableField("INITIATOR_ACCOUNT_")
    private String initiatorAccount;

    @ApiModelProperty(value = "发起人")
    @TableField("INITIATOR_NAME_")
    private String initiatorName;

    @ApiModelProperty(value = "考核类型（1月度考核，2季度考核，3年度考核，4自定义）")
    @TableField("ASSESSMENT_TYPE_")
    private String assessmentType;

    @ApiModelProperty(value = "考核年度")
    @TableField("ASSESSMENT_YEAR_")
    private Integer assessmentYear;

    @ApiModelProperty(value = "考核月度")
    @TableField("ASSESSMENT_MONTH_")
    private Integer assessmentMonth;

    @ApiModelProperty(value = "考核季度")
    @TableField("ASSESSMENT_QUATER_")
    private Integer assessmentQuater;

    @ApiModelProperty(value = "评审要求")
    @TableField("DESC_")
    private String desc;

    @ApiModelProperty(value = "总分值")
    @TableField("TOTAL_SCORE_")
    private Integer totalScore;

    @ApiModelProperty(value = "状态(1：所有供应商已完成，2：已提交待评分，3评分中，4评分完毕待评价，5取消/关闭)")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

}
