package com.artfess.gyl.supplierEva.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.gyl.base.model.BizSupplierAssessmentIndicatorType;
import com.artfess.gyl.supplierEva.dto.OrgExpandDTO;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationNotificationManager;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationNotification;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationNotificationTemplate;
import com.artfess.gyl.supplierEva.dao.BizSupplierPerformanceEvaluationNotificationTemplateDao;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationNotificationTemplateManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 供应商绩效考核通知信息表 服务实现类
 *
 * @author 管理员
 * @since 2025-12-12
 */
@Service
public class BizSupplierPerformanceEvaluationNotificationTemplateManagerImpl extends BaseManagerImpl<BizSupplierPerformanceEvaluationNotificationTemplateDao, BizSupplierPerformanceEvaluationNotificationTemplate> implements BizSupplierPerformanceEvaluationNotificationTemplateManager {

    @Resource
    private BizSupplierPerformanceEvaluationNotificationManager notificationManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean save(BizSupplierPerformanceEvaluationNotificationTemplate entity){
        entity.setStatus("0");
        return super.save(entity);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateById(BizSupplierPerformanceEvaluationNotificationTemplate entity){
        return super.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateStatusById(String id, String status) {
        BizSupplierPerformanceEvaluationNotificationTemplate entity = super.get(id);
        if (entity == null) {
            throw new ApplicationException("未找到对应模版,请刷新后尝试");
        }
        LambdaUpdateWrapper<BizSupplierPerformanceEvaluationNotificationTemplate> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(BizSupplierPerformanceEvaluationNotificationTemplate::getId, id);
        wrapper.set(BizSupplierPerformanceEvaluationNotificationTemplate::getStatus, status);
        boolean update = super.update(wrapper);
        if (!update) {
            return false;
        }
        if (status.equals("1")) {
            int distributeType = 2;
            String processType = entity.getProcessType();
            String notificationTitle = entity.getNotificationTitle();
            String notificationContent = entity.getNotificationContent();
            String enterpriseContact = entity.getEnterpriseContact();
            String enterpriseTel = entity.getEnterpriseTel();
            String enterpriseAddress = entity.getEnterpriseAddress();
            LocalDateTime notifyDate = entity.getNotifyDate();
            LocalDateTime replyDeadline = entity.getReplyDeadline();
            LocalDateTime finishDeadline = entity.getFinishDeadline();
            String assessmentType = entity.getAssessmentType();
            Integer assessmentYear = entity.getAssessmentYear();
            Integer assessmentMonth = entity.getAssessmentMonth();
            Integer assessmentQuater = entity.getAssessmentQuater();
            String currentOrgId = ContextUtil.getCurrentOrgId();
            String currentOrgName = ContextUtil.getCurrentOrgName();
            String currentOrgCode = ContextUtil.getCurrentOrgCode();
            String level = entity.getLevel();
            String valuationConfigurationName = entity.getValuationConfigurationName();
            String assessmentResult = entity.getAssessmentResult();
            IUser user = ContextUtil.getCurrentUser();
            List<OrgExpandDTO> orgList;
            Set<String> noticeIds = new HashSet<>();
            try {
                String orgExpand = entity.getOrgExpand();
                orgList = JSON.parseArray(orgExpand, OrgExpandDTO.class);
            } catch (Exception e) {
                throw new RuntimeException("解析 orgExpand JSON 失败: ", e);
            }
            if (orgList == null || orgList.isEmpty()) {
                throw new ApplicationException("无下发的供应商");
            }
            List<BizSupplierPerformanceEvaluationNotification> notifications = new ArrayList<>();
            for (OrgExpandDTO org : orgList) {
                BizSupplierPerformanceEvaluationNotification notification = new BizSupplierPerformanceEvaluationNotification();
                notification.setPerformanceEvaluationId(id);
                notification.setValuationConfigurationName(valuationConfigurationName);
                notification.setAssessmentType(assessmentType);
                notification.setAssessmentYear(assessmentYear);
                notification.setAssessmentMonth(assessmentMonth);
                notification.setAssessmentQuater(assessmentQuater);
                notification.setInitiatorId(user.getUserId());
                notification.setInitiatorAccount(user.getAccount());
                notification.setDistributeType(distributeType);
                notification.setInitiatorName(user.getFullname());
                notification.setEnterpriseId(currentOrgId);
                notification.setEnterpriseName(currentOrgName);
                notification.setEnterpriseCode(currentOrgCode);
                notification.setSupplierId(org.getSupplierId());
                notification.setSupplierName(org.getSupplierName());
                notification.setSupplierCode(org.getSupplierCode());
                notification.setProcessType(processType);
                notification.setNotificationTitle(notificationTitle);
                notification.setNotificationContent(notificationContent);
                notification.setEnterpriseContact(enterpriseContact);
                notification.setEnterpriseTel(enterpriseTel);
                notification.setEnterpriseAddress(enterpriseAddress);
                notification.setNotifyDate(notifyDate);
                notification.setReplyDeadline(replyDeadline);
                notification.setLevel(level);
                notification.setAssessmentResult(assessmentResult);
                notification.setFinishDeadline(finishDeadline);
                if (StringUtils.isNotBlank(notification.getId())) {
                    noticeIds.add(notification.getId());
                }
                notifications.add(notification);
            }
            return notificationManager.saveOrUpdateBatch(notifications);
        }
        return true;
    }

    @Override
    public boolean remove(List<String> ids) {
        LambdaQueryWrapper<BizSupplierPerformanceEvaluationNotification> notificationLambdaQueryWrapper = new LambdaQueryWrapper<>();
        notificationLambdaQueryWrapper.in(BizSupplierPerformanceEvaluationNotification::getPerformanceEvaluationId, ids);
        notificationLambdaQueryWrapper.eq(BizSupplierPerformanceEvaluationNotification::getDistributeType, 2);
        notificationManager.remove(notificationLambdaQueryWrapper);

        LambdaQueryWrapper<BizSupplierPerformanceEvaluationNotificationTemplate> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(BizSupplierPerformanceEvaluationNotificationTemplate::getId, ids);
        return super.remove(wrapper);
    }

    @Override
    @Transactional(readOnly = true)
    public BizSupplierPerformanceEvaluationNotificationTemplate getById(Serializable id) {

        BizSupplierPerformanceEvaluationNotificationTemplate entity = super.getById(id);
        if (entity == null) {
            return null;
        }

//        LambdaQueryWrapper<BizSupplierPerformanceEvaluationNotification> wrapper = new LambdaQueryWrapper<>();
//        LambdaQueryWrapper<BizSupplierPerformanceEvaluationNotification> notificationLambdaQueryWrapper = new LambdaQueryWrapper<>();
//        notificationLambdaQueryWrapper.eq(BizSupplierPerformanceEvaluationNotification::getPerformanceEvaluationId, id);
//        notificationLambdaQueryWrapper.eq(BizSupplierPerformanceEvaluationNotification::getDistributeType, 2);
////        List<BizSupplierPerformanceEvaluationNotification> notifications = notificationManager.list(wrapper);
//        entity.setNotifications(notifications);
        return entity;
    }

}
