package com.artfess.gyl.supplierEva.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationApprovalRecordManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationCorrectionReportRecordManager;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationApprovalRecord;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationCorrectionReport;
import com.artfess.gyl.supplierEva.dao.BizSupplierPerformanceEvaluationCorrectionReportDao;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationCorrectionReportManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationCorrectionReportRecord;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;

/**
 * 供应商考核整改措施报告表 服务实现类
 *
 * @author huqi
 * @since 2025-11-12
 */
@Service
public class BizSupplierPerformanceEvaluationCorrectionReportManagerImpl extends BaseManagerImpl<BizSupplierPerformanceEvaluationCorrectionReportDao, BizSupplierPerformanceEvaluationCorrectionReport> implements BizSupplierPerformanceEvaluationCorrectionReportManager {

    @Resource
    private BizSupplierPerformanceEvaluationCorrectionReportRecordManager recordManager;


    public void saveReportResult(BizSupplierPerformanceEvaluationCorrectionReport report, String approvalOpinion) {
        IUser user = ContextUtil.getCurrentUser();

        // 1. 保存审批记录
        saveApprovalRecord(report, approvalOpinion, user);

//        // 2. 如果是终审状态，保存用户评分记录
//        if (isFinalApprovalStatus(report.getCorrectionStatus())) {
//            saveUserRatingRecord(report, user);
//        }
    }

    /**
     * 保存审批记录
     */
    private void saveApprovalRecord(BizSupplierPerformanceEvaluationCorrectionReport report, String approvalOpinion, IUser user) {
        String correctionStatus = report.getCorrectionStatus();

        BizSupplierPerformanceEvaluationCorrectionReportRecord record = new BizSupplierPerformanceEvaluationCorrectionReportRecord();

        // 设置基础信息
        setBasicInfo(record, report);

        // 设置节点状态
        setNodeStatus(record, correctionStatus);

        // 设置审批人信息
        setApproverInfo(record, user);

        // 设置审批结果
        setApprovalResult(record, correctionStatus, approvalOpinion);

        recordManager.save(record);
    }

//    /**
//     * 保存用户评分记录
//     */
//    private void saveUserRatingRecord(BizSupplierPerformanceEvaluationCorrectionReport report, IUser user) {
//        BizSupplierPerformanceEvaluationApprovalRecord approvalRecord = new BizSupplierPerformanceEvaluationApprovalRecord();
//
//        // 设置评分状态（3对应1，5对应5）
//        String ratingStatus = "3".equals(report.getCorrectionStatus())||"4".equals(report.getCorrectionStatus()) ? "1" : "5";
//        approvalRecord.setStatus(ratingStatus);
//        approvalRecord.setPerformanceEvaluationId(report.getPerformanceEvaluationId());
//
//        // 设置审批人信息
//        setApproverInfo(approvalRecord, user);
//
//        approvalRecordManager.fillModel(approvalRecord);
//    }

    /**
     * 设置基础信息
     */
    private void setBasicInfo(BizSupplierPerformanceEvaluationCorrectionReportRecord record,
                              BizSupplierPerformanceEvaluationCorrectionReport report) {
        record.setPerformanceEvaluationId(report.getPerformanceEvaluationId());
        record.setPerformanceEvaluationCorrectionReportId(report.getId());
        record.setNotificationId(report.getNotificationId());
        record.setJobNum("1");
        record.setStatus(report.getCorrectionStatus());
    }

    /**
     * 设置节点状态
     */
    private void setNodeStatus(BizSupplierPerformanceEvaluationCorrectionReportRecord record, String correctionStatus) {
        // 首节点：状态为1时是首节点
        record.setFirstNode("1".equals(correctionStatus) ? "1" : "0");
        // 尾节点：状态为3或5时是尾节点
        record.setTailNode("3".equals(correctionStatus) || "5".equals(correctionStatus) ? "1" : "0");
    }

    /**
     * 设置审批人信息（通用方法）
     */
    private void setApproverInfo(Object record, IUser user) {
        if (record instanceof BizSupplierPerformanceEvaluationCorrectionReportRecord) {
            BizSupplierPerformanceEvaluationCorrectionReportRecord target = (BizSupplierPerformanceEvaluationCorrectionReportRecord) record;
            target.setApprovalId(user.getUserId());
            target.setApprovalAccount(user.getAccount());
            target.setApprovalName(user.getFullname());
            target.setApprovalOrgId(ContextUtil.getCurrentOrgId());
            target.setApprovalOrgCode(ContextUtil.getCurrentOrgCode());
            target.setApprovalOrgName(ContextUtil.getCurrentOrgName());
        } else if (record instanceof BizSupplierPerformanceEvaluationApprovalRecord) {
            BizSupplierPerformanceEvaluationApprovalRecord target = (BizSupplierPerformanceEvaluationApprovalRecord) record;
            target.setApprovalId(user.getUserId());
            target.setApprovalAccount(user.getAccount());
            target.setApprovalName(user.getFullname());
            target.setApprovalOrgId(ContextUtil.getCurrentOrgId());
            target.setApprovalOrgName(ContextUtil.getCurrentOrgName());
            target.setApprovalOrgCode(ContextUtil.getCurrentOrgCode());
        }
    }

    /**
     * 设置审批结果
     */
    private void setApprovalResult(BizSupplierPerformanceEvaluationCorrectionReportRecord record,
                                   String correctionStatus, String approvalOpinion) {
        record.setApprovalDate(LocalDateTime.now());
        // 状态为4时审批结果为0（拒绝），其他情况为1（通过）
        record.setApprovalResult("4".equals(correctionStatus) ? "0" : "1");
        record.setApprovalOpinion(approvalOpinion);
    }

    /**
     * 判断是否为终审状态
     */
    private boolean isFinalApprovalStatus(String correctionStatus) {
        return "3".equals(correctionStatus) || "5".equals(correctionStatus);
    }
}
