package com.artfess.gyl.supplierEva.manager.impl;

import cn.hutool.core.lang.Assert;
import com.artfess.base.exception.ApplicationException;
import com.artfess.gyl.base.model.BizSupplierMaterialCategory;
import com.artfess.gyl.supplierEva.dto.UserBindRequestDTO;
import com.artfess.gyl.supplierEva.dto.ConfigurationDTO;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationConfigurationUserManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationDetailsManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationIntervalManager;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationConfiguration;
import com.artfess.gyl.supplierEva.dao.BizSupplierPerformanceEvaluationConfigurationDao;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationConfigurationManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationConfigurationUser;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationDetails;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationInterval;
import com.artfess.gyl.supplierEva.vo.ConfigurationVo;
import com.artfess.gyl.supplierEva.vo.SupplierBaseVo;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

/**
 * 供应商绩效考核配置表 服务实现类
 *
 * @author huqi
 * @since 2025-11-11
 */
@Service
public class BizSupplierPerformanceEvaluationConfigurationManagerImpl extends BaseManagerImpl<BizSupplierPerformanceEvaluationConfigurationDao, BizSupplierPerformanceEvaluationConfiguration> implements BizSupplierPerformanceEvaluationConfigurationManager {

    @Resource
    private SysIdentityManager sysIdentityManager;

    @Resource
    private BizSupplierPerformanceEvaluationDetailsManager detailsManager;

    @Resource
    private BizSupplierPerformanceEvaluationIntervalManager intervalManager;

    @Resource
    private BizSupplierPerformanceEvaluationConfigurationUserManager configurationUserManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean savaModel(ConfigurationDTO dto) {
        Assert.notNull(dto.getDetails(),"配置详情不能为空");
        Assert.notNull(dto.getIntervals(),"得分项不能为空");
        String code = sysIdentityManager.nextId("gyszrpzbm");
        dto.setCode(code);
        boolean save = super.save(dto);
        if (!save) {
            return false;
        }
        //更新评审详情
        List<BizSupplierPerformanceEvaluationDetails> details = dto.getDetails();
//        int totalScore = details.stream()
//                .filter(score->score.getScore() !=null && score.getScore() > 0)
//                .mapToInt(BizSupplierPerformanceEvaluationDetails::getScore)
//                .sum();
//        if (totalScore!=dto.getTotalScore()) {
//            throw new ApplicationException("分值不匹配");
//        }
        details.forEach(detail -> {
            detail.setPerformanceEvaluationConfigurationId(dto.getId());
            detail.setStatus("1");
            detail.setCode(UUID.randomUUID().toString().replace("-", "").substring(0,8));
        });
        detailsManager.saveBatch(details);
       //更新评分项
        List<BizSupplierPerformanceEvaluationInterval> intervals = dto.getIntervals();
        intervals.forEach(detail -> {
            detail.setPerformanceEvaluationConfigurationId(dto.getId());
        });
        intervalManager.saveBatch(intervals);
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateModel(ConfigurationDTO dto) {
        Assert.notNull(dto.getDetails(),"配置详情不能为空");
        Assert.notNull(dto.getIntervals(),"得分项不能为空");
        boolean update = super.updateById(dto);
        if (!update) {
            return false;
        }

        //删除之前评审项
        detailsManager.remove(new LambdaQueryWrapper<BizSupplierPerformanceEvaluationDetails>()
                .eq(BizSupplierPerformanceEvaluationDetails::getPerformanceEvaluationConfigurationId, dto.getId()));
        //更新评审详情
        List<BizSupplierPerformanceEvaluationDetails> details = dto.getDetails();
        details.forEach(detail -> {
            detail.setId(null);
            detail.setPerformanceEvaluationConfigurationId(dto.getId());
            detail.setCode(UUID.randomUUID().toString().replace("-", "").substring(0,8));
            detail.setStatus("1");
        });
        detailsManager.saveBatch(details);

        //删除之前评分项
        intervalManager.remove(new LambdaQueryWrapper<BizSupplierPerformanceEvaluationInterval>()
                .eq(BizSupplierPerformanceEvaluationInterval::getPerformanceEvaluationConfigurationId, dto.getId()));
        //更新评分项
        List<BizSupplierPerformanceEvaluationInterval> intervals = dto.getIntervals();
        intervals.forEach(detail -> {
            detail.setId(null);
            detail.setPerformanceEvaluationConfigurationId(dto.getId());
        });
        intervalManager.saveBatch(intervals);
        return true;
    }

    @Override
    @Transactional(readOnly = true)
    public ConfigurationVo getModel(String id) {
        BizSupplierPerformanceEvaluationConfiguration configuration = super.getById(id);
        ConfigurationVo vo = new ConfigurationVo(configuration);
        if (configuration != null) {
            List<BizSupplierPerformanceEvaluationDetails> details = detailsManager.list(new LambdaQueryWrapper<BizSupplierPerformanceEvaluationDetails>()
                    .eq(BizSupplierPerformanceEvaluationDetails::getPerformanceEvaluationConfigurationId, id));
            vo.setDetails(details);
            List<BizSupplierPerformanceEvaluationInterval> intervals = intervalManager.list(new LambdaQueryWrapper<BizSupplierPerformanceEvaluationInterval>()
                    .eq(BizSupplierPerformanceEvaluationInterval::getPerformanceEvaluationConfigurationId, id));
            vo.setIntervals(intervals);
        }
        return vo;
    }

    @Override
    @Transactional(rollbackFor =  Exception.class)
    public boolean updateStatusById(String id, String status) {
        LambdaUpdateWrapper<BizSupplierPerformanceEvaluationConfiguration> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(BizSupplierPerformanceEvaluationConfiguration::getId, id);
        wrapper.set(BizSupplierPerformanceEvaluationConfiguration::getStatus, status);
        if (!this.update(wrapper)){
            return false;
        }
        //当修改为禁用状态的时候，删除已绑定的用户
        if ("0".equals(status)){
            LambdaQueryWrapper<BizSupplierPerformanceEvaluationConfigurationUser> rmWrapper = new LambdaQueryWrapper<BizSupplierPerformanceEvaluationConfigurationUser>()
                    .eq(BizSupplierPerformanceEvaluationConfigurationUser::getValuationConfigurationId, id);
            configurationUserManager.remove(rmWrapper);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean bindUser(UserBindRequestDTO dto) {
        BizSupplierPerformanceEvaluationConfiguration configuration = super.get(dto.getId());
        if (configuration == null) {
            throw new ApplicationException("未找到相关配置");
        }
        List<String> supplierIds = dto.getConfigurationUsers().stream().map(BizSupplierPerformanceEvaluationConfigurationUser::getSupplierId).collect(Collectors.toList());
        //删除之前绑定的数据
        LambdaQueryWrapper<BizSupplierPerformanceEvaluationConfigurationUser> rmWrapper = new LambdaQueryWrapper<BizSupplierPerformanceEvaluationConfigurationUser>()
                .eq(BizSupplierPerformanceEvaluationConfigurationUser::getCreateOrgId, ContextUtil.getCurrentOrgId())
                .and(wrapper -> wrapper
                        .or(subWrapper1 -> subWrapper1
                                .ne(BizSupplierPerformanceEvaluationConfigurationUser::getValuationConfigurationId, dto.getId())
                                .in(BizSupplierPerformanceEvaluationConfigurationUser::getSupplierId, supplierIds)
                        )
                        .or(subWrapper2 -> subWrapper2
                                .eq(BizSupplierPerformanceEvaluationConfigurationUser::getValuationConfigurationId, dto.getId())
                        )
                );
        configurationUserManager.remove(rmWrapper);
        //更新数据
        List<BizSupplierPerformanceEvaluationConfigurationUser> configurationUsers = dto.getConfigurationUsers();
        configurationUsers.forEach(user -> {
            user.setValuationConfigurationId(dto.getId());
            user.setId(null);
        });
        configurationUserManager.saveOrUpdateBatch(configurationUsers);
        return true;
    }

    @Override
    public List<SupplierBaseVo> getSuppliers(String enterpriseId,String configId, String categoryId) {
        return baseMapper.getSupplierEnterprise(enterpriseId,configId,categoryId);
    }


}
