package com.artfess.gyl.supplierEva.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.gyl.supplierEva.dto.EvaluationDTO;
import com.artfess.gyl.supplierEva.dto.ResultEvaDTO;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluation;
import com.artfess.base.manager.BaseManager;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationRatingUser;
import com.artfess.gyl.supplierEva.vo.*;

import java.util.List;

/**
 * 供应商绩效考核评价表 服务类
 *
 * @author huqi
 * @since 2025-11-12
 */
public interface BizSupplierPerformanceEvaluationManager extends BaseManager<BizSupplierPerformanceEvaluation> {

    /**
     * 分组新增考核-根据模板中的供应商级别批量新增考核评分体系
     * @param dto
     * @return
     */
    boolean batchCreateEvaluationFromTemplate(EvaluationDTO dto);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    EvaluationResultVo getModelById(String id);

    /**
     * 根据用户查询查询详情
     * @param id
     * @return
     */
    EvaluationOptVo getModelByUser(String id);

    /**
     * 根据id查询评标情况
     * @param
     * @return
     */
    List<SupplierScore> getUserRatings(String evaluationId, String detailsId);

    /**
     * 根据id查询评标情况
     * @param
     * @return
     */
    List<SupplierScore> getUserEvaluations(String ratingId);

    /**
     * 通用查询
     * @param queryFilter
     * @return
     */
    PageList<EvaluationVo> queryEvaluationList(QueryFilter<BizSupplierPerformanceEvaluation> queryFilter);

    /**
     * 通用查询
     * @param queryFilter
     * @return
     */
    PageList<EvaluationVo> queryEvaluationListByUser(QueryFilter<BizSupplierPerformanceEvaluation> queryFilter, String account);

    /**
     * 根据账号查询汇总打分情况
     * @param queryFilter
     * @return
     */
    PageList<EvaluationVo> queryByPersonalSum(QueryFilter<BizSupplierPerformanceEvaluation> queryFilter);

    /**
     * 通用查询
     * @param queryFilter
     * @return
     */
    PageList<CorePerformanceVo> queryBySupplierLevel(QueryFilter<BizSupplierPerformanceEvaluation> queryFilter);

    /**
     * 保存用户评分接口
     * @param ratingList
     * @return
     */
    boolean saveUserRating(List<BizSupplierPerformanceEvaluationRatingUser> ratingList);

    /**
     * 提交用户评分接口
     * @param evaId
     * @return
     */
    boolean submitUserRating(String evaId);

    /**
     * 用户评价接口
     * @param dto
     * @return
     */
    boolean submitUserEvaluation(ResultEvaDTO dto);

    /**
     * 删除数据
     * @param idList
     * @return
     */
    boolean remove(List<String> idList);

    /**
     * 根据id修改
     * @param idList
     * @return
     */
    boolean updateByIds(List<String> idList,Integer status);
}
