package com.artfess.gyl.supplierEva.manager;

import com.artfess.gyl.supplierEva.dto.UserBindRequestDTO;
import com.artfess.gyl.supplierEva.dto.ConfigurationDTO;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationConfiguration;
import com.artfess.base.manager.BaseManager;
import com.artfess.gyl.supplierEva.vo.ConfigurationVo;
import com.artfess.gyl.supplierEva.vo.SupplierBaseVo;

import java.util.List;

/**
 * 供应商绩效考核配置表 服务类
 *
 * @author huqi
 * @since 2025-11-11
 */
public interface BizSupplierPerformanceEvaluationConfigurationManager extends BaseManager<BizSupplierPerformanceEvaluationConfiguration> {

    /**
     * 新增评分项
     * @param dto
     * @return
     */
    boolean savaModel(ConfigurationDTO dto);

    /**
     * 新增评分项
     * @param dto
     * @return
     */
    boolean updateModel(ConfigurationDTO dto);

    /**
     * 查询详情
     * @return
     */
    ConfigurationVo getModel(String id);

    /**
     * 根据id修改启用状态
     * @param id
     * @return
     */
    boolean updateStatusById(String id,String status);

    /**
     * 供应商绑定配置表
     * @param dto
     * @return
     */
    boolean bindUser(UserBindRequestDTO dto);

    /**
     * 根据供应商分类查询合格供应商
     * @param enterpriseId
     * @return
     */
    List<SupplierBaseVo> getSuppliers(String enterpriseId,String configId, String categoryId);


}
