package com.artfess.gyl.supplierEva.dto;

import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

@Data
public class ProcessDTO {

    @ApiModelProperty(value = "整改报告单id")
    private String reportId;

    @ApiModelProperty(value = "通知单id")
    private String notificationId;

    @ApiModelProperty(value = "通知状态")
    private String status;

    @ApiModelProperty(value = "考核评价id")
    private String performanceEvaluationId;

    @ApiModelProperty(value = "根本原因分析")
    @TableField("root_cause_analysis_")
    private String rootCauseAnalysis;

    @ApiModelProperty(value = "临时应急措施")
    @TableField("temporary_measure_")
    private String temporaryMeasure;

    @ApiModelProperty(value = "长期纠正措施	")
    @TableField("long_term_correction_")
    private String longTermCorrection;

    @ApiModelProperty(value = "计划完成日期")
    @TableField("plan_complete_date_")
    private LocalDate planCompleteDate;

    @ApiModelProperty(value = "实际完成日期")
    @TableField("actual_complete_date_")
    private LocalDate actualCompleteDate;

    @ApiModelProperty(value = "整改状态(1进行中，2已完成，3已验收，4已关闭)")
    @TableField("correction_status_")
    private String correctionStatus;

    @ApiModelProperty(value = "整改结果描述")
    @TableField("result_description_")
    private String resultDescription;

    @ApiModelProperty(value = "整改结果描述")
    @TableField("result_description_")
    private String approvalOpinion;

    @ApiModelProperty(value = "附件集")
    private List<DefaultFile> files;
}
