package com.artfess.gyl.supplierApply3.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商主供物资分类表
 *
 * @author huqi
 * @since 2025-11-17
 */
@Data
@TableName("biz_supplier_main_supply_material_category3")
@ApiModel(value="BizSupplierMainSupplyMaterialCategory3对象", description="供应商主供物资分类表")
public class BizSupplierMainSupplyMaterialCategory3 extends BizDelModel<BizSupplierMainSupplyMaterialCategory3> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "合格供应商ID")
    @TableField("SUPPLIER_ENTERPRISE_ID_")
    private String supplierEnterpriseId;

    @ApiModelProperty(value = "基础物料分类ID")
    @TableField("CATEGORY_ID_")
    private String categoryId;

    @ApiModelProperty(value = "基础物料分类编号")
    @TableField("CATEGORY_PLATCODE_")
    private String categoryPlatcode;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;

    @ApiModelProperty(value = "附件集")
    @TableField(exist = false)
    private List<DefaultFile> files;
}
