package com.artfess.gyl.supplierApply3.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 合格供应商注册信息，在准入申请时默认查询出此数据并填充，如果没有此数据准入申请通过后默认添加一条此数据
 *
 * @author huqi
 * @since 2025-11-17
 */
@Data
@TableName("biz_supplier_enterprise_register_information")
@ApiModel(value="BizSupplierEnterpriseRegisterInformation对象", description="合格供应商注册信息，在准入申请时默认查询出此数据并填充，如果没有此数据准入申请通过后默认添加一条此数据")
public class BizSupplierEnterpriseRegisterInformation extends BizDelModel<BizSupplierEnterpriseRegisterInformation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "准入申请ID（关联准入申请表ID）")
    @TableField("SUPPLIER_ENTERPRISE_ACCESS_ID_")
    private String supplierEnterpriseAccessId;

    @ApiModelProperty(value = "准入申请流水号")
    @TableField("SUPPLIER_ACCESS_NUMBER_")
    private String supplierAccessNumber;

    @ApiModelProperty(value = "企业ID")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码（企业平台编码）")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "企业名称（企业平台编码）")
    @TableField("ENTERPRISE_NAME_")
    private String enterpriseName;

    @ApiModelProperty(value = "申请时间")
    @TableField("APPLY_DATE")
    private LocalDate applyDate;

    @ApiModelProperty(value = "入选时间")
    @TableField("SELECTION_DATE")
    private LocalDate selectionDate;

    @ApiModelProperty(value = "推荐部门")
    @TableField("RECOMMENDED_DEPARTMENT_")
    private String recommendedDepartment;

    @ApiModelProperty(value = "推荐人")
    @TableField("REFERRER_")
    private String referrer;

    @ApiModelProperty(value = "上次考核时间")
    @TableField("LAST_ASSESSMENT_DATE_")
    private LocalDate lastAssessmentDate;

    @ApiModelProperty(value = "上次考核类型（与考核评价中类型一致）")
    @TableField("LAST_ASSESSMENT_TYPE")
    private String lastAssessmentType;

    @ApiModelProperty(value = "上次考核得分/级别")
    @TableField("LAST_ASSESSMENT_SCORE_")
    private String lastAssessmentScore;

    @ApiModelProperty(value = "上次交易时间")
    @TableField("LAST_TRANSACTION_TIME_")
    private LocalDate lastTransactionTime;

    @ApiModelProperty(value = "交易状态（1：正常，2：冻结）")
    @TableField("TRANSACTION_STATUS_")
    private String transactionStatus;

    @ApiModelProperty(value = "类型（1合格供应商，2退出供应商，3淘汰供应商）")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "创建方式（1企业直接添加，2供应商准入申请，3企业准入申请）")
    @TableField("CREATE_METHOD_")
    private String createMethod;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "综合评分（预留字段）")
    @TableField("OVERALL_RATING_")
    private Integer overallRating;

    @ApiModelProperty(value = "综合评价（预留字段）")
    @TableField("COMPREHENSIVE_EVALUATION_")
    private String comprehensiveEvaluation;

    @ApiModelProperty(value = "组织编号（税号）")
    @TableField("COMPANY_ORGCODE_")
    private String companyOrgcode;

    @ApiModelProperty(value = "法人")
    @TableField("COMPANY_EBE_")
    private String companyEbe;

    @ApiModelProperty(value = "注册日期")
    @TableField("COMPANY_REGDATE_")
    private LocalDate companyRegdate;

    @ApiModelProperty(value = "注册有效期至")
    @TableField("COMPANY_REGDATE_END_")
    private String companyRegdateEnd;

    @ApiModelProperty(value = "省份")
    @TableField("PROVINCE_")
    private String province;

    @ApiModelProperty(value = "城市")
    @TableField("CITY_")
    private String city;

    @ApiModelProperty(value = "区县")
    @TableField("COUNTY_")
    private String county;

    @ApiModelProperty(value = "企业地址")
    @TableField("COMPANY_ADDR_")
    private String companyAddr;

    @ApiModelProperty(value = "联系人")
    @TableField("COMPANY_CONTACT_")
    private String companyContact;

    @ApiModelProperty(value = "联系电话")
    @TableField("CONTACT_TEL_")
    private String contactTel;

    @ApiModelProperty(value = "企业类型")
    @TableField("OWNER_TYPE_")
    private String ownerType;

    @ApiModelProperty(value = "注册资金(万元)")
    @TableField("REGISTERED_CAPITAL_")
    private Double registeredCapital;

    @ApiModelProperty(value = "注册资金类型（1.人民币，2.美元，3.英镑，4.日元，5.港币）")
    @TableField("REGISTERED_CAPITAL_TYPE_")
    private Integer registeredCapitalType;

    @ApiModelProperty(value = "邮箱")
    @TableField("MAIL_")
    private String mail;

    @ApiModelProperty(value = "邮政编码")
    @TableField("POST_CODE_")
    private String postCode;

    @ApiModelProperty(value = "统一社会信用代码")
    @TableField("CREDIT_CODE_")
    private String creditCode;

    @ApiModelProperty(value = "联行号")
    @TableField("INTERBANK_")
    private String interbank;

    @ApiModelProperty(value = "银行账号")
    @TableField("BANK_")
    private String bank;

    @ApiModelProperty(value = "开户银行")
    @TableField("OPENING_BANK_")
    private String openingBank;

    @ApiModelProperty(value = "邮寄地址")
    @TableField("MAILING_ADDRESS_")
    private String mailingAddress;

    @ApiModelProperty(value = "纳税人类型（1:一般纳税人，2:小规模纳税人，3:个人，默认1）")
    @TableField("TAXPAYER_TYPE_")
    private Integer taxpayerType;

    @ApiModelProperty(value = "历史企业编号对应浪潮")
    @TableField("HISTORY_COMPANY_CODE_")
    private String historyCompanyCode;

    @ApiModelProperty(value = "注册类型（0：企业，1：个人，默认0）")
    @TableField("REGIS_TYPE_")
    private Integer regisType;

    @ApiModelProperty(value = "行业分类编号（关联国民经济行业分类表编号）")
    @TableField("INDUSTRY_CODE_")
    private String industryCode;

    @ApiModelProperty(value = "行业分类名称（关联国民经济行业分类表名称）")
    @TableField("INDUSTRY_NAME_")
    private String industryName;

    @ApiModelProperty(value = "公司简称")
    @TableField("ENTERPRISE_SHORT_NAME_")
    private String enterpriseShortName;

    @ApiModelProperty(value = "经营范围")
    @TableField("BUSINESS_SCOPE_")
    private String businessScope;
}
