package com.artfess.gyl.supplierApply3.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 合格供应商资质表	说明：供应商资质变更后通过资质编码和版本号进行对比，如果没有则添加一条资质信息（版本号加1
 *
 * @author huqi
 * @since 2025-11-17
 */
@Data
@TableName("biz_supplier_enterprise_qualification3")
@ApiModel(value="BizSupplierEnterpriseQualification3对象", description="合格供应商资质表	说明：供应商资质变更后通过资质编码和版本号进行对比，如果没有则添加一条资质信息（版本号加1")
public class BizSupplierEnterpriseQualification3 extends BizDelModel<BizSupplierEnterpriseQualification3> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "资质所属（1：企业，2：个人）")
    @TableField("QUALIFICATION_ATTRIBUTION_")
    private String qualificationAttribution;

    @ApiModelProperty(value = "姓名（资质为个人时填写）")
    @TableField("FULL_NAME_")
    private String fullName;

    @ApiModelProperty(value = "企业ID")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "所属行业")
    @TableField("INDUSTRY_")
    private String industry;

    @ApiModelProperty(value = "资质类型编码（关联资质类型表编码）")
    @TableField("QUALIFICATION_CATEGORY_CODE_")
    private String qualificationCategoryCode;

    @ApiModelProperty(value = "资质类型名称")
    @TableField("QUALIFICATION_CATEGORY_NAME_")
    private String qualificationCategoryName;

    @ApiModelProperty(value = "资质全称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "资质编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "发证机构")
    @TableField("ISSUING_AUTHORITY_")
    private String issuingAuthority;

    @ApiModelProperty(value = "发证日期")
    @TableField("ISSUE_DATE_")
    private LocalDate issueDate;

    @ApiModelProperty(value = "有效期截止")
    @TableField("VALID_UNTIL_")
    private LocalDate validUntil;

    @ApiModelProperty(value = "状态(1：正常，:2：到期，3：异常)")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "附件集")
    @TableField(exist = false)
    private List<DefaultFile> files;
}
