package com.artfess.gyl.supplierApply3.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.gyl.supplierApply3.dto.SupplierRegisterDTO;
import com.artfess.gyl.supplierEva.dto.EvaluationDTO;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.supplierApply3.model.BizSupplierEnterpriseRegisterInformation;
import com.artfess.gyl.supplierApply3.manager.BizSupplierEnterpriseRegisterInformationManager;

import javax.validation.Valid;

/**
 * 合格供应商注册信息，在准入申请时默认查询出此数据并填充，如果没有此数据准入申请通过后默认添加一条此数据 前端控制器
 *
 * @author huqi
 * @since 2025-11-17
 */
@RestController
@RequestMapping("/bizSupplierEnterpriseRegisterInformation/v1/")
@Api(tags = "供应商注册")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizSupplierEnterpriseRegisterInformationController extends BaseController<BizSupplierEnterpriseRegisterInformationManager, BizSupplierEnterpriseRegisterInformation> {

    @PostMapping("/saveOrUpdateModel")
    @ApiOperation("保存供应商注册")
    public CommonResult<String> saveOrUpdateModel(@ApiParam(name = "model", value = "实体信息") @Valid @RequestBody SupplierRegisterDTO dto) {
        Boolean result = baseService.saveOrUpdateModel(dto);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(dto,"操作成功");
    }

    @GetMapping("/getModel/{id}")
    @ApiOperation("根据id查询详情")
    public CommonResult<String> getModel(@PathVariable("id")String id) {
        return CommonResult.success(baseService.getById(id),"操作成功");
    }

    @GetMapping("/getModel/supplier/{id}")
    @ApiOperation("根据供应商id查询详情")
    public CommonResult<String> getBySupplierId(@PathVariable("id")String id) {
        return CommonResult.success(baseService.getBySupplierId(id),"操作成功");
    }

    @Override
    @PostMapping(value = "/query", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询结果")
    public PageList<BizSupplierEnterpriseRegisterInformation> query(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizSupplierEnterpriseRegisterInformation> queryFilter) {
        queryFilter.addFilter("i.ENTERPRISE_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        return baseService.queryByVersion(queryFilter);
    }



}
