package com.artfess.gyl.supplierApply2.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商主供物资分类表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-17
 */
@Data
@ApiModel(value="BizSupplierMainSupplyMaterialCategory2对象", description="供应商主供物资分类表")
public class BizSupplierMainSupplyMaterialCategory2 extends BizDelModel<BizSupplierMainSupplyMaterialCategory2> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "供应商准入ID")
    @TableField("SUPPLIER_ENTERPRISE_ID_")
    private String supplierEnterpriseId;

    @ApiModelProperty(value = "基础物料分类ID")
    @TableField("CATEGORY_ID_")
    private String categoryId;

    @ApiModelProperty(value = "基础物料分类编号")
    @TableField("CATEGORY_PLATCODE_")
    private String categoryPlatcode;

    @ApiModelProperty(value = "基础物料分类名称")
    @TableField("CATEGORY_NAME_")
    private String categoryName;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;
}
