package com.artfess.gyl.supplierApply2.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;

import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商准入资质库（版本号与资质库版本保持一致，需要变更资质时，供应商现在资质管理中修改，然后查看资质关联企业发布变更）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-10
 */
@Data
@ApiModel(value="BizSupplierEnterpriseQualificationDatabase2对象", description="供应商准入资质库（版本号与资质库版本保持一致，需要变更资质时，供应商现在资质管理中修改，然后查看资质关联企业发布变更）")
public class BizSupplierEnterpriseQualificationDatabase2 extends BizDelModel<BizSupplierEnterpriseQualificationDatabase2> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "供应商准入ID")
    @TableField("SUPPLIER_ENTERPRISE_ID_")
    private String supplierEnterpriseId;

    @ApiModelProperty(value = "资质库ID（关联资质库表ID）")
    @TableField("SUPPLIER_QUALIFICATION_DATABASE_ID_")
    private String supplierQualificationDatabaseId;

    @ApiModelProperty(value = "是否必传资质（0必传资质，1代理资质）")
    @TableField("MUST_TRANSMIT_")
    private String mustTransmit;

    @ApiModelProperty(value = "资质所属（1：企业，2：个人）")
    @TableField("QUALIFICATION_ATTRIBUTION_")
    private String qualificationAttribution;

    @ApiModelProperty(value = "姓名（资质为个人时填写）")
    @TableField("FULL_NAME_")
    private String fullName;

    @ApiModelProperty(value = "企业ID")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "所属行业")
    @TableField("INDUSTRY_")
    private String industry;

    @ApiModelProperty(value = "资质类型编码（关联资质类型表编码）")
    @TableField("QUALIFICATION_CATEGORY_CODE_")
    private String qualificationCategoryCode;

    @ApiModelProperty(value = "资质类型名称")
    @TableField("QUALIFICATION_CATEGORY_NAME_")
    private String qualificationCategoryName;

    @ApiModelProperty(value = "资质全称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "资质编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "发证机构")
    @TableField("ISSUING_AUTHORITY_")
    private String issuingAuthority;

    @ApiModelProperty(value = "发证日期")
    @TableField("ISSUE_DATE_")
    private LocalDate issueDate;

    @ApiModelProperty(value = "有效期截止")
    @TableField("VALID_UNTIL_")
    private LocalDate validUntil;

    @ApiModelProperty(value = "状态(1：正常，:2：到期，3：异常)")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;
}
