package com.artfess.gyl.supplierApply2.dto;

import com.artfess.gyl.supplierApply2.model.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class EnterpriseAccess2Dto extends BizSupplierEnterpriseAccess {

    @ApiModelProperty(value = "模块(1基本情况，2人员信息，3企业规模，4企业资质，5主营产品情况，6主营产品质量业绩，7主要原材料及供应商，8生产制造过程绩效，9生产设备，10检验设备，11其他特别说明，12现场评审，13评定报告，14试生产审评)")
    private String moduleCode;

    @ApiModelProperty(value = "供应商主供物资分类")
    private List<BizSupplierMainSupplyMaterialCategory2> materialCategory2List;

    @ApiModelProperty(value = "供应商基本情况")
    private BizSupplierAccessBasicInformation2 information;

    @ApiModelProperty(value = "企业资质（1必传资质，2选传资质，3其他资质）-Map集合")
    private Map<String, List<BizSupplierEnterpriseQualificationDatabase2>> qualificationMap;

    @ApiModelProperty(value = "主营产品质量业绩")
    private MainProductsPerformance2Dto mainProductsPerformance;

    @ApiModelProperty(value = "主要原材料及供应商")
    private List<BizSupplierMainRawMaterialsSuppliers2>  rawMaterialsSuppliersList;

    @ApiModelProperty(value = "生产制造过程绩效")
    private BizSupplierProductionProcessPerformance2Dto processPerformance;

    @ApiModelProperty(value = "生产及检验设备（1生产设备，2监测设备）-Map集合")
    private Map<String,List<BizSupplierProductionInspectionEquipment2>> inspectionEquipmentMap;

    @ApiModelProperty(value = "其他特别说明")
    private BizSupplierOtherSpecialNotes2 otherSpecialNotes;

    @ApiModelProperty(value = "现场评审")
    private Map<String,List<BizSupplierReviewRatingDetails2Dto>> reviewRatingDetails2Map;

    @ApiModelProperty(value = "评定报告")
    private BizSupplierReviewReport2Dto reviewReport;

    @ApiModelProperty(value = "试生产评审")
    private BizSupplierReviewTrialReport2Dto reviewTrialReport;

//    @ApiModelProperty(value = "人员信息")
//    private Map<String,List<BizSupplierAccessPersonnel2>> accessPersonnelMap;

    @ApiModelProperty(value = "人员信息")
    private List<BizSupplierAccessEnterprisePersonnel2> enterprisePersonnelList;

    @ApiModelProperty(value = "主营产品情况")
    private List<BizSupplierMainProductsSalesStatus2> salesStatus2List;

    @ApiModelProperty(value = "主要检验设备")
    private List<BizSupplierInspectionEquipment2> inspectionEquipment2List;

    @ApiModelProperty(value = "主要生产设备")
    private List<BizSupplierProductionEquipment2> productionEquipment2List;
}
