package com.artfess.gyl.supplierApply2.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.valid.AddGroup;
import com.artfess.gyl.base.model.BizEnterpriseBusinessLicense;
import com.artfess.gyl.base.model.BizSupplierQualificationDatabase;
import com.artfess.gyl.supplierAccess.dto.BizSupplierAccessConfigurationDto;
import com.artfess.gyl.supplierAccess.model.BizSupplierAccessConfiguration;
import com.artfess.gyl.supplierAccess.vo.BizSupplierAccessConfigurationVo;
import com.artfess.gyl.supplierAccess.vo.BizSupplierReviewConfigurationVo;
import com.artfess.gyl.supplierApply2.dto.EnterpriseAccess2Dto;
import com.artfess.gyl.supplierApply2.model.*;
import com.artfess.gyl.supplierApply2.vo.EnterpriseAccess2PageVo;
import com.artfess.gyl.supplierApply2.vo.EnterpriseAccess2Vo;
import com.artfess.gyl.supplierApply2.vo.FillingProgressVo;
import com.artfess.gyl.thirdParty.model.BizEnterprise;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.supplierApply2.manager.BizSupplierEnterpriseAccessManager;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;

/**
 * 供应商准入申请表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-10
 */
@RestController
@RequestMapping("/bizSupplierEnterpriseAccess/v1/")
@Api(tags = "供应商准入申请表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizSupplierEnterpriseAccessController extends BaseController<BizSupplierEnterpriseAccessManager, BizSupplierEnterpriseAccess> {

    @PostMapping("/saveOrUpdateEnterpriseAccess")
    @ApiOperation("保存/修改-准入申请信息")
    public CommonResult<String> saveOrUpdateEnterpriseAccess(@ApiParam(name = "model", value = "实体信息") @Validated({AddGroup.class}) @RequestBody EnterpriseAccess2Dto dto) {
        Boolean result = baseService.saveOrUpdateEnterpriseAccess(dto);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(dto,"保存成功");
    }

    @PostMapping("/saveOrUpdateOtherInfo")
    @ApiOperation("保存/修改-准入申请其他信息")
    public CommonResult<String> saveOrUpdateOtherInfo(@ApiParam(name = "model", value = "实体信息") @Validated({AddGroup.class}) @RequestBody EnterpriseAccess2Dto dto) {
        Boolean result = baseService.saveOrUpdateOtherInfo(dto);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(dto,"保存成功");
    }

    @GetMapping("/getInfo/{id}")
    @ApiOperation("查询-准入申请信息详情")
    public EnterpriseAccess2Vo getInfo(@ApiParam(name = "id", value = "实体id") @PathVariable String id){
        return baseService.getInfo(id);
    }

    @PostMapping(value = "/queryPage", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询-准入申请列表")
    public PageList<EnterpriseAccess2PageVo> queryPage(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizSupplierEnterpriseAccess> queryFilter,
                                                       @ApiParam(name = "role", value = "供应商还是企业查询（1企业，2供应商）") @RequestParam String role) throws InvocationTargetException, IllegalAccessException {
        IUser user = ContextUtil.getCurrentUser();
        queryFilter.addFilter("sea.IS_DELE_", "0", QueryOP.EQUAL);
        if (!Objects.requireNonNull(user).isAdmin()){
            if ("1".equals(role)){
                queryFilter.addFilter("sea.ENTERPRISE_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
            }
            if ("2".equals(role)){
                queryFilter.addFilter("sea.SUPPLIER_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
            }
        }
        return baseService.queryPage(queryFilter);
    }

    @GetMapping("/getFillingProgress")
    @ApiOperation("查询-准入申请信息填报进度")
    public FillingProgressVo getFillingProgress(@RequestParam String id){
        return baseService.getFillingProgress(id);
    }

    @GetMapping("/getMenu")
    @ApiOperation("查询-准入申请菜单")
    public FillingProgressVo getMenu(@RequestParam String categoryId,
                                     @ApiParam(name = "id", value = "准入申请ID") @RequestParam(required = false) String id){
        return baseService.getMenu(categoryId,id);
    }


    @GetMapping("/getSupplierBasicInfo")
    @ApiOperation("查询供应商基本信息")
    public BizEnterpriseBusinessLicense getSupplierBasicInfo(@RequestParam String supplierId){
        return baseService.getSupplierBasicInfo(supplierId);
    }

    @GetMapping("/getOwnerEnterprise")
    @ApiOperation("查询企业信息")
    public BizEnterprise getOwnerEnterprise(){
        return baseService.getOwnerEnterprise();
    }

//    @GetMapping("/getQualificationByEnterpriseId")
//    @ApiOperation("查询-准入资质")
//    public List<BizSupplierQualificationDatabase> getQualificationByEnterpriseId(@ApiParam(name = "enterpriseId", value = "企业ID") @RequestParam String enterpriseId,
//                                                                                 @ApiParam(name = "type", value = "资质类型（1必填资质，2选填资质，3其他资质）") @RequestParam String type){
//        return baseService.getQualificationByEnterpriseId(enterpriseId,type);
//    }

    @GetMapping("/getQualification")
    @ApiOperation("准入申请查询资质")
    public List<BizSupplierQualificationDatabase> getQualification(@ApiParam(name = "categoryId", value = "供应物资ID") @RequestParam String categoryId,
                                                                                 @ApiParam(name = "type", value = "资质类型（1必填资质，2代理资质）") @RequestParam String type){
        return baseService.getQualification(categoryId,type);
    }

    @GetMapping("/submit")
    @ApiOperation("提交-准入申请")
    public CommonResult<String> submit(@RequestParam String id){
        Boolean result = baseService.submit(id);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(id,"提交成功");
    }

    @PostMapping("/audit")
    @ApiOperation("审批-准入申请")
    public CommonResult<String> audit(@RequestBody BizSupplierEnterpriseAccessApprovalRecord2 accessApprovalRecord2) throws InvocationTargetException, IllegalAccessException {
        Boolean result = baseService.audit(accessApprovalRecord2);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(null,"保存成功");
    }

    @GetMapping("/queryApprovalLogs")
    @ApiOperation("查询-审批日志")
    public List<BizSupplierEnterpriseAccessApprovalRecord2> queryApprovalLogs(@RequestParam String id){
        return baseService.queryApprovalLogs(id);
    }

    @GetMapping("/getReviewConfiguration")
    @ApiOperation("查询-准入评审配置")
    public List<BizSupplierReviewConfigurationVo> getReviewConfiguration(@RequestParam String id){
        return baseService.getReviewConfiguration(id);
    }

    @GetMapping("/getReportPanel")
    @ApiOperation("查询-评审成员")
    public List<BizSupplierReviewReportPanel2> getReportPanel(@RequestParam String id){
        return baseService.getReportPanel(id);
    }

    @GetMapping("/getTrialReportPanel")
    @ApiOperation("查询-试用评审报告评审成员成员")
    public List<BizSupplierReviewTrialReportPanel2> getTrialReportPanel(@RequestParam String id){
        return baseService.getTrialReportPanel(id);
    }

    @GetMapping("/getEnterpriseScore")
    @ApiOperation("查询-计算现场评审评分")
    public CommonResult<String> getEnterpriseScore(@RequestParam String id){
        String result = baseService.getEnterpriseScore(id);
        return CommonResult.success(result,"保存成功");
    }

    @GetMapping("/getAffiliatedEnterprise")
    @ApiOperation("查询-关联企业")
    public List<BizEnterprise> getAffiliatedEnterprise(@RequestParam String supplierId,@RequestParam String... phones){
        return baseService.getAffiliatedEnterprise(phones,supplierId);
    }

    @GetMapping("/getEnterprisePersonnel")
    @ApiOperation("抓取企业人员信息")
    public List<BizSupplierAccessEnterprisePersonnel2> getEnterprisePersonnel(@ApiParam(name = "supplierId", value = "供应商企业ID") @RequestParam String supplierId) throws InvocationTargetException, IllegalAccessException {
        return baseService.getEnterprisePersonnel(supplierId);
    }

    @GetMapping("/getAccessConfiguration")
    @ApiOperation("企业根据物资类型查询准入配置")
    public BizSupplierAccessConfiguration getAccessConfiguration(@ApiParam(name = "categoryId", value = "物资类型ID") @RequestParam String categoryId){
        return baseService.getAccessConfiguration(categoryId);
    }

}
