package com.artfess.gyl.supplierApply.vo;

import com.artfess.gyl.supplierApply.model.*;
import com.artfess.gyl.supplierApply2.model.*;
import com.artfess.gyl.supplierApply2.vo.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.beanutils.BeanUtils;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

@Data
public class EnterpriseVo extends BizSupplierEnterprise {

    @ApiModelProperty(value = "供应商主供物资分类")
    private List<BizSupplierMainSupplyMaterialCategory> materialCategoryList;

    @ApiModelProperty(value = "供应商基本情况")
    private BizSupplierAccessBasicInformationVo information;

    @ApiModelProperty(value = "企业资质（1必传资质，2选传资质，3其他资质）-Map集合")
    private Map<String, List<BizSupplierEnterpriseQualificationDatabase>> qualificationMap;

    @ApiModelProperty(value = "主营产品质量业绩")
    private MainProductsPerformanceVo mainProductsPerformance;

    @ApiModelProperty(value = "主要原材料及供应商")
    private List<BizSupplierMainRawMaterialsSuppliers>  rawMaterialsSuppliersList;

    @ApiModelProperty(value = "生产制造过程绩效")
    private BizSupplierProductionProcessPerformanceVo processPerformance;

    @ApiModelProperty(value = "生产及检验设备（1生产设备，2监测设备）-Map集合")
    private Map<String,List<BizSupplierProductionInspectionEquipment>> inspectionEquipmentMap;

    @ApiModelProperty(value = "其他特别说明")
    private BizSupplierOtherSpecialNotes otherSpecialNotes;

    @ApiModelProperty(value = "现场评审")
    private Map<String,List<BizSupplierReviewRatingDetailsVo>> reviewRatingDetailsMap;

    @ApiModelProperty(value = "评定报告")
    BizSupplierReviewReportVo reviewReport;

    @ApiModelProperty(value = "试生产评审")
    BizSupplierReviewTrialReportVo reviewTrialReport;


    @ApiModelProperty(value = "人员信息")
    private List<BizSupplierAccessEnterprisePersonnel> enterprisePersonnelList;

    @ApiModelProperty(value = "主营产品情况")
    List<BizSupplierMainProductsSalesStatus> salesStatusList;

    @ApiModelProperty(value = "主要检验设备")
    private List<BizSupplierInspectionEquipment> inspectionEquipmentList;

    @ApiModelProperty(value = "主要生产设备")
    private List<BizSupplierProductionEquipment> productionEquipmentList;

    public EnterpriseVo(){}

    public EnterpriseVo(BizSupplierEnterprise enterprise){
        try {
            BeanUtils.copyProperties(this,enterprise);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}
