package com.artfess.gyl.supplierApply.vo;

import com.artfess.base.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class EnterprisePageVo {

    @ApiModelProperty(value = "合格供应商ID")
    private String id;

    @ApiModelProperty(value = "客户ID")
    private String enterpriseId;

    @ApiModelProperty(value = "客户编码（企业平台编码）")
    private String enterpriseCode;

    @ApiModelProperty(value = "客户名称")
    private String enterpriseName;

    @ApiModelProperty(value = "供方ID")
    private String supplierId;

    @ApiModelProperty(value = "供方编码（企业平台编码）")
    private String supplierCode;

    @ApiModelProperty(value = "供方名称")
    private String companyName;

    @ApiModelProperty(value = "类型")
    private String ownerType;

    @ApiModelProperty(value = "法定代表人")
    private String companyEbe;

    @ApiModelProperty(value = "注册资金(万元)")
    private Double registeredCapital;

    @TableField("CAT_NAME_")
    private String catName;

    @TableField("GRADING_NAME_")
    private String gradingName;

    @ApiModelProperty(value = "订单总金额")
    private String totalAmount;

    @ApiModelProperty(value = "申请时间")
    private LocalDateTime applyDate;

    @ApiModelProperty(value = "类型（1合格供应商，2退出供应商，3淘汰供应商）")
    @TableField("TYPE_")
    private String type;
}
