package com.artfess.gyl.supplierApply.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 其他特别说明表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-20
 */
@Data
@ApiModel(value="BizSupplierOtherSpecialNotes对象", description="其他特别说明表")
public class BizSupplierOtherSpecialNotes extends BizDelModel<BizSupplierOtherSpecialNotes> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "合格供应商ID")
    @TableField("SUPPLIER_ENTERPRISE_ID_")
    private String supplierEnterpriseId;

    @ApiModelProperty(value = "其他说明")
    @TableField("NOTES_")
    private String notes;

    @ApiModelProperty(value = "附件集")
    @TableField(exist = false)
    private List<DefaultFile> files;
}
