package com.artfess.gyl.supplierApply.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.gyl.supplierApply.dto.EnterpriseDto;
import com.artfess.gyl.supplierApply.model.BizSupplierEnterprise;
import com.artfess.base.manager.BaseManager;
import com.artfess.gyl.supplierApply.vo.EnterprisePageVo;
import com.artfess.gyl.supplierApply.vo.EnterpriseVo;
import com.artfess.gyl.supplierApply.vo.SupplierCountVo;
import com.artfess.gyl.supplierApply2.vo.FillingProgressVo;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * 合格供应商表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-20
 */
public interface BizSupplierEnterpriseManager extends BaseManager<BizSupplierEnterprise> {

    /**
     * 保存-合格供应商
     * @param dto
     * @return
     */
    Boolean saveModel(EnterpriseDto dto);

    /**
     * 查询-合格供应商详情
     * @param id
     * @return
     */
    EnterpriseVo getInfo(String id);

    public void saveFullModel(EnterpriseDto dto);

    /**
     * 分页查询-合格供应商列表
     * @param queryFilter
     * @return
     */
    PageList<EnterprisePageVo> queryPage(QueryFilter<BizSupplierEnterprise> queryFilter) throws InvocationTargetException, IllegalAccessException;

    /**
     * 根据企业查询供应商等级情况
     * @param queryFilter
     * @return
     */
    PageList<SupplierCountVo> countSupplierGrade(QueryFilter<BizSupplierEnterprise> queryFilter);

    /**
     * 查询详情菜单
     * @param id
     * @return
     */
    FillingProgressVo getFillingProgress(String id);

    /**
     * 导入合格供应商
     * @param list
     * @return
     */
    boolean importEnterprise(List<BizSupplierEnterprise> list);
}
