package com.artfess.gyl.supplierApply.dao;

import com.artfess.gyl.supplierApply.model.BizSupplierEnterprise;
import com.artfess.gyl.supplierApply.vo.EnterprisePageVo;
import com.artfess.gyl.supplierApply.vo.SupplierCountVo;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluation;
import com.artfess.gyl.supplierEva.vo.EvaluationVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 合格供应商表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-20
 */
public interface BizSupplierEnterpriseDao extends BaseMapper<BizSupplierEnterprise> {

    /**
     * 分页查询
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<SupplierCountVo> countSupplierGrade(IPage<BizSupplierEnterprise> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BizSupplierEnterprise> convert2Wrapper);

    IPage<EnterprisePageVo> queryPage(IPage<BizSupplierEnterprise> convert2IPage,
                                      @Param(Constants.WRAPPER) QueryWrapper<BizSupplierEnterprise> convert2Wrapper);
}
