package com.artfess.gyl.supplierApply.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.valid.AddGroup;
import com.artfess.gyl.supplierApply.dto.EnterpriseDto;
import com.artfess.gyl.supplierApply.vo.EnterprisePageVo;
import com.artfess.gyl.supplierApply.vo.EnterpriseVo;
import com.artfess.gyl.supplierApply.vo.SupplierCountVo;
import com.artfess.gyl.supplierApply2.dto.EnterpriseAccess2Dto;
import com.artfess.gyl.supplierApply2.model.BizSupplierEnterpriseAccess;
import com.artfess.gyl.supplierApply2.vo.EnterpriseAccess2PageVo;
import com.artfess.gyl.supplierApply2.vo.EnterpriseAccess2Vo;
import com.artfess.gyl.supplierApply2.vo.FillingProgressVo;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.supplierApply.model.BizSupplierEnterprise;
import com.artfess.gyl.supplierApply.manager.BizSupplierEnterpriseManager;
import org.springframework.web.multipart.MultipartFile;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;

/**
 * 合格供应商表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-20
 */
@RestController
@RequestMapping("/bizSupplierEnterprise/v1/")
@Api(tags = "合格供应商表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizSupplierEnterpriseController extends BaseController<BizSupplierEnterpriseManager, BizSupplierEnterprise> {

    @PostMapping("/saveModel")
    @ApiOperation("保存-合格供应商")
    public CommonResult<String> saveModel(@ApiParam(name = "model", value = "实体信息") @Validated({AddGroup.class}) @RequestBody EnterpriseDto dto) {
        Boolean result = baseService.saveModel(dto);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(dto,"保存成功");
    }

    @GetMapping("/getInfo/{id}")
    @ApiOperation("查询-合格供应商详情")
    public EnterpriseVo getInfo(@ApiParam(name = "id", value = "实体id") @PathVariable String id){
        return baseService.getInfo(id);
    }

    @PostMapping(value = "/queryPage", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询-合格供应商列表")
    public PageList<EnterprisePageVo> queryPage(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizSupplierEnterprise> queryFilter,
                                                @ApiParam(name = "role", value = "供应商还是企业查询（1企业，2供应商）") @RequestParam String role) throws InvocationTargetException, IllegalAccessException {
        IUser user = ContextUtil.getCurrentUser();
        queryFilter.addFilter("se.IS_DELE_", "0", QueryOP.EQUAL);
        if (!Objects.requireNonNull(user).isAdmin()){
            if ("1".equals(role)){
                queryFilter.addFilter("se.ENTERPRISE_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
            }
            if ("2".equals(role)){
                queryFilter.addFilter("se.SUPPLIER_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
            }
        }
        return baseService.queryPage(queryFilter);
    }

    @GetMapping("/getFillingProgress")
    @ApiOperation("查询详情菜单")
    public FillingProgressVo getFillingProgress(@RequestParam String id){
        return baseService.getFillingProgress(id);
    }

    @PostMapping("/importEnterprise")
    @ApiOperation("导入合格供应商")
    public CommonResult<String> importEnterprise(@RequestBody MultipartFile file) {
        try {
            ExcelUtils<BizSupplierEnterprise> excelUtil = new ExcelUtils<>(BizSupplierEnterprise.class);
            List<BizSupplierEnterprise> list = excelUtil.importExcel(null,file.getInputStream(),1);
            boolean result = baseService.importEnterprise(list);
            if (!result) {
                throw new IllegalArgumentException("导入失败，系统没有检测到任何有效数据");
            }
            return new CommonResult<>();
        } catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("导入失败，请检查上传的格式"+e.getMessage());
        }
    }
}
