package com.artfess.gyl.supplierAccess.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商准入评审评分配置表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-09
 */
@Data
@ApiModel(value="BizSupplierReviewConfiguration对象", description="供应商准入评审评分配置表")
public class BizSupplierReviewConfiguration extends AutoFillFullModel<BizSupplierReviewConfiguration> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "企业ID")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "配置编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "配置名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "基础物料分类ID")
    @TableField("CATEGORY_ID_")
    private String categoryId;

    @ApiModelProperty(value = "基础物料分类编号")
    @TableField("CATEGORY_PLATCODE_")
    private String categoryPlatcode;

    @ApiModelProperty(value = "评审要求")
    @TableField("DESC_")
    private String desc;

    @ApiModelProperty(value = "总分值")
    @TableField("TOTAL_SCORE_")
    private Integer totalScore;

    @ApiModelProperty(value = "状态(1：启用，0：禁用)")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;
}
