package com.artfess.gyl.report;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.gyl.supplierApply.manager.BizSupplierEnterpriseManager;
import com.artfess.gyl.supplierApply.model.BizSupplierEnterprise;
import com.artfess.gyl.supplierApply.vo.SupplierCountVo;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationManager;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluation;
import com.artfess.gyl.supplierEva.vo.CorePerformanceVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RestController
@RequestMapping("/reportAnalysis/v1/")
@Api(tags = "报表统计")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class ReportAnalysisController {

    @Resource
    private BizSupplierEnterpriseManager enterpriseManager;

    @Resource
    private BizSupplierPerformanceEvaluationManager evaluationManager;

    @PostMapping(value = "/queryBySupplierGrade", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询-企业下合格供应商等级分类明细")
    public PageList<SupplierCountVo> countSupplierGrade(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizSupplierEnterprise> queryFilter) {
        queryFilter.addFilter("se.TYPE_","1", QueryOP.EQUAL);
        queryFilter.addFilter("be.ORG_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        return enterpriseManager.countSupplierGrade(queryFilter);
    }

    @PostMapping(value = "/queryBySupplierLevel", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询-供应商绩效考核情况")
    public PageList<CorePerformanceVo> queryBySupplierLevel(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        return evaluationManager.queryBySupplierLevel(queryFilter);
    }

}
